/*
 * Decompiled with CFR 0.152.
 */
package guide;

import java.util.ArrayList;
import org.zeromq.ZContext;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public class spqueue {
    private static final String WORKER_READY = "\u0001";

    public static void main(String[] args) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                spqueue.notmain(new String[0]);
            }
        });
        thread.start();
    }

    public static void notmain(String[] args) {
        try (ZContext ctx = new ZContext();){
            ZMQ.Socket frontend = ctx.createSocket(6);
            ZMQ.Socket backend = ctx.createSocket(6);
            frontend.bind("tcp://*:6555");
            backend.bind("tcp://*:6556");
            ArrayList<ZFrame> workers = new ArrayList<ZFrame>();
            ZMQ.Poller poller = new ZMQ.Poller(2);
            poller.register(backend, 1);
            poller.register(frontend, 1);
            while (true) {
                ZMsg msg;
                boolean workersAvailable = workers.size() > 0;
                int rc = poller.poll(-1L);
                if (rc == -1) break;
                if (poller.pollin(0)) {
                    msg = ZMsg.recvMsg((ZMQ.Socket)backend);
                    if (msg == null) break;
                    ZFrame address = msg.unwrap();
                    workers.add(address);
                    ZFrame frame = msg.getFirst();
                    if (new String(frame.getData()).equals(WORKER_READY)) {
                        msg.destroy();
                    } else {
                        msg.send(frontend);
                    }
                }
                if (!workersAvailable || !poller.pollin(1) || (msg = ZMsg.recvMsg((ZMQ.Socket)frontend)) == null) continue;
                msg.wrap((ZFrame)workers.remove(0));
                msg.send(backend);
            }
            while (workers.size() > 0) {
                ZFrame frame = (ZFrame)workers.remove(0);
                frame.destroy();
            }
            workers.clear();
        }
    }
}

