/*
 * Decompiled with CFR 0.152.
 */
package guide;

import java.util.Arrays;
import java.util.Random;
import org.zeromq.ZMQ;

public class rtdealer {
    static final String URI = "ipc://routing.ipc";
    static final int NOFLAGS = 0;
    private static Random rand = new Random();

    public static void main(String[] args) throws InterruptedException {
        ZMQ.Context context = ZMQ.context((int)1);
        ZMQ.Socket socket = context.socket(6);
        socket.bind(URI);
        Thread workerA = new Thread(new Worker("A"));
        Thread workerB = new Thread(new Worker("B"));
        workerA.start();
        workerB.start();
        System.out.println("Workers started, sleeping 1 second for warmup.");
        Thread.sleep(1000L);
        for (int i = 0; i < 10; ++i) {
            byte[] address = rand.nextInt() % 3 == 0 ? "B".getBytes() : "A".getBytes();
            socket.send(address, 2);
            socket.send("This is the workload.".getBytes(), 0);
        }
        socket.send("A".getBytes(), 2);
        socket.send("END".getBytes(), 0);
        socket.send("B".getBytes(), 2);
        socket.send("END".getBytes(), 0);
        socket.close();
        context.term();
    }

    public static class Worker
    implements Runnable {
        public final String name;
        private final byte[] END = "END".getBytes();

        Worker(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            ZMQ.Context context = ZMQ.context((int)1);
            ZMQ.Socket socket = context.socket(5);
            socket.setIdentity(this.name.getBytes());
            socket.connect(rtdealer.URI);
            int total = 0;
            boolean finished = false;
            while (!finished) {
                byte[] data = socket.recv(0);
                if (Arrays.equals(data, this.END)) {
                    finished = true;
                    System.out.println(String.format("Worker %s received %d messages.", this.name, total));
                }
                ++total;
            }
            socket.close();
            context.term();
        }
    }
}

