/*
 * Decompiled with CFR 0.152.
 */
package guide;

import java.util.Random;
import org.zeromq.ZContext;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public class ppworker {
    private static final int HEARTBEAT_LIVENESS = 3;
    private static final int HEARTBEAT_INTERVAL = 1000;
    private static final int INTERVAL_INIT = 1000;
    private static final int INTERVAL_MAX = 32000;
    private static final String PPP_READY = "\u0001";
    private static final String PPP_HEARTBEAT = "\u0002";

    private static ZMQ.Socket worker_socket(ZContext ctx) {
        ZMQ.Socket worker = ctx.createSocket(5);
        worker.connect("tcp://localhost:5556");
        System.out.println("I: worker ready\n");
        ZFrame frame = new ZFrame(PPP_READY);
        frame.send(worker, 0);
        return worker;
    }

    public static void main(String[] args) {
        try (ZContext ctx = new ZContext();){
            int rc;
            ZMQ.Socket worker = ppworker.worker_socket(ctx);
            ZMQ.Poller poller = new ZMQ.Poller(1);
            poller.register(worker, 1);
            int liveness = 3;
            int interval = 1000;
            long heartbeat_at = System.currentTimeMillis() + 1000L;
            Random rand = new Random(System.nanoTime());
            int cycles = 0;
            while ((rc = poller.poll(1000L)) != -1) {
                if (poller.pollin(0)) {
                    block26: {
                        ZMsg msg = ZMsg.recvMsg((ZMQ.Socket)worker);
                        if (msg == null) {
                            break;
                        }
                        if (msg.size() == 3) {
                            if (++cycles > 3 && rand.nextInt(5) == 0) {
                                System.out.println("I: simulating a crash\n");
                                msg.destroy();
                                msg = null;
                                break;
                            }
                            if (cycles > 3 && rand.nextInt(5) == 0) {
                                System.out.println("I: simulating CPU overload\n");
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException e) {
                                    break;
                                }
                            }
                            System.out.println("I: normal reply\n");
                            msg.send(worker);
                            liveness = 3;
                            try {
                                Thread.sleep(1000L);
                                break block26;
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        if (msg.size() == 1) {
                            ZFrame frame = msg.getFirst();
                            String frameData = new String(frame.getData());
                            if (PPP_HEARTBEAT.equals(frameData)) {
                                liveness = 3;
                            } else {
                                System.out.println("E: invalid message\n");
                                msg.dump((Appendable)System.out);
                            }
                            msg.destroy();
                        } else {
                            System.out.println("E: invalid message\n");
                            msg.dump((Appendable)System.out);
                        }
                    }
                    interval = 1000;
                } else if (--liveness == 0) {
                    System.out.println("W: heartbeat failure, can't reach queue\n");
                    System.out.printf("W: reconnecting in %sd msec\n", interval);
                    try {
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (interval < 32000) {
                        interval *= 2;
                    }
                    ctx.destroySocket(worker);
                    worker = ppworker.worker_socket(ctx);
                    liveness = 3;
                }
                if (System.currentTimeMillis() <= heartbeat_at) continue;
                long now = System.currentTimeMillis();
                heartbeat_at = now + 1000L;
                ZFrame frame = new ZFrame(PPP_HEARTBEAT);
                frame.send(worker, 0);
            }
        }
    }
}

