/*
 * Decompiled with CFR 0.152.
 */
package guide;

import java.util.ArrayList;
import java.util.Iterator;
import org.zeromq.ZContext;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public class ppque {
    private static final int HEARTBEAT_LIVENESS = 3;
    private static final int HEARTBEAT_INTERVAL = 1000;
    private static final String PPP_READY = "\u0001";
    private static final String PPP_HEARTBEAT = "\u0002";

    public static void main(String[] args) {
        try (ZContext ctx = new ZContext();){
            ZMQ.Socket frontend = ctx.createSocket(6);
            ZMQ.Socket backend = ctx.createSocket(6);
            frontend.bind("tcp://*:5555");
            backend.bind("tcp://*:5556");
            ArrayList<Worker> workers = new ArrayList<Worker>();
            long heartbeat_at = System.currentTimeMillis() + 1000L;
            ZMQ.Poller poller = new ZMQ.Poller(2);
            poller.register(backend, 1);
            poller.register(frontend, 1);
            while (true) {
                Object msg;
                boolean workersAvailable = workers.size() > 0;
                int rc = poller.poll(1000L);
                if (rc == -1) break;
                if (poller.pollin(0)) {
                    msg = ZMsg.recvMsg((ZMQ.Socket)backend);
                    if (msg == null) break;
                    ZFrame address = msg.unwrap();
                    Worker worker = new Worker(address);
                    worker.ready(workers);
                    if (msg.size() == 1) {
                        ZFrame frame = msg.getFirst();
                        String data = new String(frame.getData());
                        if (!data.equals(PPP_READY) && !data.equals(PPP_HEARTBEAT)) {
                            System.out.println("E: invalid message from worker");
                            msg.dump((Appendable)System.out);
                        }
                        msg.destroy();
                    } else {
                        msg.send(frontend);
                    }
                }
                if (workersAvailable && poller.pollin(1)) {
                    msg = ZMsg.recvMsg((ZMQ.Socket)frontend);
                    if (msg == null) break;
                    msg.push(Worker.next(workers));
                    msg.send(backend);
                }
                if (System.currentTimeMillis() >= heartbeat_at) {
                    for (Worker worker : workers) {
                        worker.address.send(backend, 130);
                        ZFrame frame = new ZFrame(PPP_HEARTBEAT);
                        frame.send(backend, 0);
                    }
                    long now = System.currentTimeMillis();
                    heartbeat_at = now + 1000L;
                }
                Worker.purge(workers);
            }
            workers.clear();
        }
    }

    private static class Worker {
        ZFrame address;
        String identity;
        long expiry;

        protected Worker(ZFrame address) {
            this.address = address;
            this.identity = new String(address.getData());
            this.expiry = System.currentTimeMillis() + 3000L;
        }

        protected void ready(ArrayList<Worker> workers) {
            Iterator<Worker> it = workers.iterator();
            while (it.hasNext()) {
                Worker worker = it.next();
                if (!this.identity.equals(worker.identity)) continue;
                it.remove();
                break;
            }
            workers.add(this);
        }

        protected static ZFrame next(ArrayList<Worker> workers) {
            Worker worker = workers.remove(0);
            assert (worker != null);
            ZFrame frame = worker.address;
            return frame;
        }

        protected static void purge(ArrayList<Worker> workers) {
            Iterator<Worker> it = workers.iterator();
            while (it.hasNext()) {
                Worker worker = it.next();
                if (System.currentTimeMillis() < worker.expiry) break;
                it.remove();
            }
        }
    }
}

