/*
 * Decompiled with CFR 0.152.
 */
package hkube.communication.zmq;

import hkube.communication.ICommConfig;
import hkube.communication.IRequest;
import hkube.model.HeaderContentPair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public class ZMQRequest
implements IRequest {
    ZMQ.Socket socket;
    ZMQ.Socket pingSocket;
    String remoteURL;
    Integer timeOut;
    Integer networkTimeOut;
    private static final Logger logger = LogManager.getLogger();

    public ZMQRequest(String host, String port, ICommConfig config) {
        ZContext context = new ZContext();
        this.socket = context.createSocket(3);
        this.pingSocket = context.createSocket(3);
        this.timeOut = config.getTimeout();
        this.networkTimeOut = config.getNetworkTimeout();
        this.remoteURL = "tcp://" + host + ":" + port;
        this.socket.connect(this.remoteURL);
        String pingUrl = "tcp://" + host + ":" + (Integer.valueOf(port) + 1);
        this.pingSocket.connect(pingUrl);
    }

    public List<HeaderContentPair> send(byte[] data) throws TimeoutException {
        this.pingSocket.setReceiveTimeOut(this.networkTimeOut.intValue());
        this.pingSocket.setSendTimeOut(this.networkTimeOut.intValue());
        this.pingSocket.send("ping".getBytes(), 0);
        byte[] reslut = this.pingSocket.recv();
        if (reslut == null || !new String(reslut).equals("pong")) {
            throw new TimeoutException();
        }
        this.socket.setReceiveTimeOut(this.timeOut.intValue());
        this.socket.setSendTimeOut(this.timeOut.intValue());
        this.socket.send(data, 0);
        ArrayList<HeaderContentPair> headerContentPairs = new ArrayList<HeaderContentPair>();
        byte[] header = this.socket.recv();
        byte[] body = this.socket.recv();
        headerContentPairs.add(new HeaderContentPair(header, body));
        boolean hasMore = this.socket.hasReceiveMore();
        while (hasMore) {
            header = this.socket.recv();
            body = this.socket.recv();
            headerContentPairs.add(new HeaderContentPair(header, body));
            hasMore = this.socket.hasReceiveMore();
        }
        if (header == null || body == null) {
            throw new TimeoutException();
        }
        logger.debug("reply from " + this.remoteURL);
        return headerContentPairs;
    }

    public void close() {
        this.socket.close();
    }
}

