/*
 * Decompiled with CFR 0.152.
 */
package hkube.algo.wrapper;

import hkube.algo.wrapper.IAlgorithm;
import hkube.api.IHKubeAPI;
import hkube.communication.streaming.IStreamingManagerMsgListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatelessWrapper
implements IAlgorithm {
    boolean active = false;
    Exception exec;
    IHKubeAPI api;
    IAlgorithm originalAlgorithm;
    Map options;
    private static final Logger logger = LogManager.getLogger();

    public StatelessWrapper(IAlgorithm originalAlg) {
        this.originalAlgorithm = originalAlg;
    }

    public void Init(Map args) {
        this.options = args;
    }

    public Object Start(Map input, IHKubeAPI hkubeAPI) throws Exception {
        this.api = hkubeAPI;
        hkubeAPI.registerInputListener(new IStreamingManagerMsgListener(){

            public void onMessage(Object msg, String origin) {
                StatelessWrapper.this.invokeAlgorithm(msg, origin);
            }
        });
        this.active = true;
        hkubeAPI.startMessageListening();
        while (this.active) {
            if (this.exec != null) {
                throw this.exec;
            }
            Thread.sleep(1L);
        }
        return null;
    }

    void invokeAlgorithm(Object msg, String origin) {
        HashMap args = new HashMap(this.options);
        HashMap<String, Object> streamingInput = new HashMap<String, Object>();
        streamingInput.put("message", msg);
        streamingInput.put("origin", origin);
        args.put("streamInput", streamingInput);
        this.originalAlgorithm.Init(args);
        try {
            Object result = this.originalAlgorithm.Start(args, this.api);
            if (this.options.get("childs") != null && ((List)this.options.get("childs")).size() > 0) {
                this.api.sendMessage(result);
            }
        }
        catch (Exception e) {
            this.exec = e;
        }
    }

    public void Stop() {
        logger.info("Stopping stateless");
        this.active = false;
        this.originalAlgorithm.Stop();
    }

    public void Cleanup() {
        this.active = false;
        this.originalAlgorithm.Stop();
    }
}

