/*
 * Decompiled with CFR 0.152.
 */
package hkube.algo.wrapper;

import hkube.communication.ICommConfig;
import hkube.storage.IStorageConfig;
import hkube.storage.fs.IFSConfig;
import hkube.storage.s3.IS3Config;
import hkube.utils.Config;

public class WrapperConfig
extends Config {
    public ICommConfig commConfig = new CommConfig();
    public StorageConfig storageConfig = new StorageConfig();
    public FSConfig fsConfig = new FSConfig();
    public S3Config s3Config = new S3Config();

    public String getPort() {
        return this.getStrEnvValue("WORKER_SOCKET_PORT", "3000");
    }

    public String getHost() {
        return this.getStrEnvValue("WORKER_SOCKET_HOST", "localhost");
    }

    public String getAlgorithmClassName() {
        return this.getStrEnvValue("ALGORITHM_ENTRY_POINT", null);
    }

    public String getEncodingType() {
        return this.getStrEnvValue("WORKER_ALGORITHM_ENCODING", "bson");
    }

    public String getUrl() {
        try {
            return this.getStrEnvValue("WORKER_SOCKET_URL", null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String getStorageVersion() {
        return "v2";
    }

    class S3Config
    extends Config
    implements IS3Config {
        S3Config() {
        }

        public String getAccessKeyId() {
            return this.getStrEnvValue("AWS_ACCESS_KEY_ID", "AKIAIOSFODNN7EXAMPLE");
        }

        public String getSecretAccessKey() {
            return this.getStrEnvValue("AWS_SECRET_ACCESS_KEY", "wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY");
        }
    }

    class FSConfig
    extends Config
    implements IFSConfig {
        FSConfig() {
        }

        public String getBaseDir() {
            return this.getStrEnvValue("BASE_FS_ADAPTER_DIRECTORY", "/var/tmp/fs/storage");
        }
    }

    class StorageConfig
    extends Config
    implements IStorageConfig {
        StorageConfig() {
        }

        public String getStorageType() {
            return this.getStrEnvValue("DEFAULT_STORAGE", "fs");
        }

        public String getClusterName() {
            return this.getStrEnvValue("CLUSTER_NAME", "local");
        }

        public Config getTypeSpecificConfig() {
            if (this.getStorageType().equals("fs")) {
                return WrapperConfig.this.fsConfig;
            }
            return WrapperConfig.this.s3Config;
        }

        public String getEncodingType() {
            return this.getStrEnvValue("STORAGE_ENCODING", "msgpack");
        }
    }

    class CommConfig
    extends Config
    implements ICommConfig {
        CommConfig() {
        }

        public Integer getMaxCacheSize() {
            return this.getNumericEnvValue("DISCOVERY_MAX_CACHE_SIZE", 500);
        }

        public String getListeningPort() {
            return this.getStrEnvValue("DISCOVERY_PORT", "9020");
        }

        public String getListeningHost() {
            return this.getStrEnvValue("POD_IP", "127.0.0.1");
        }

        public String getEncodingType() {
            return this.getStrEnvValue("DISCOVERY_ENCODING", "msgpack");
        }

        public Integer getTimeout() {
            return this.getNumericEnvValue("DISCOVERY_TIMEOUT", 20000);
        }

        public Integer getNetworkTimeout() {
            return this.getNumericEnvValue("DISCOVERY_NETWORK_TIMEOUT", 1000);
        }
    }
}

