/*
 * Decompiled with CFR 0.152.
 */
package hkube.algo.wrapper;

import hkube.caching.DecodedCache;
import hkube.model.ObjectAndSize;
import hkube.storage.TaskStorage;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.StringUtils;

public class StorageProxy {
    DecodedCache decodedCache = new DecodedCache();
    TaskStorage storage;

    StorageProxy(TaskStorage storage) {
        this.storage = storage;
    }

    public Object get(String path) throws FileNotFoundException {
        Object result = this.decodedCache.get(path);
        if (result == null) {
            ObjectAndSize objectAndSize = this.storage.getByFullPath(path);
            result = objectAndSize.getValue();
            if (path.endsWith("result.json")) {
                ((List)result).forEach(resultPartReference -> {
                    String message;
                    Map info = (Map)((Map)resultPartReference).get("info");
                    if (info != null && (message = (String)info.get("message")) != null && message.contains("too large")) {
                        String partPath = (String)info.get("path");
                        try {
                            ObjectAndSize resultPart = this.storage.getByFullPath(partPath);
                            ((Map)resultPartReference).put("result", resultPart.getValue());
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            this.decodedCache.put(path, objectAndSize.getValue(), objectAndSize.getSize());
        }
        return result;
    }

    public Object get(String jobId, String taskId) throws FileNotFoundException {
        String path = TaskStorage.createPath((String)jobId, (String)taskId);
        Object result = this.decodedCache.get(path);
        if (result == null) {
            ObjectAndSize objectAndSize = this.storage.get(jobId, taskId);
            this.decodedCache.put(path, objectAndSize.getValue(), objectAndSize.getSize());
        }
        return result;
    }

    public void setToCache(String jobId, String taskId, Object value, Integer size) {
        String path = TaskStorage.createPath((String)jobId, (String)taskId);
        this.setToCache(path, value, size);
    }

    public void setToCache(String path, Object value, Integer size) {
        this.decodedCache.put(path, value, size);
    }

    public void setToCache(Map storageInfo, Object value, Integer size) {
        String storageFullPath = (String)storageInfo.get("path");
        this.setToCache(storageFullPath, value, size);
    }

    public Object getInputParamFromStorage(Map storageInfo, String path) {
        Object value;
        String storageFullPath = (String)storageInfo.get("path");
        try {
            Object storedData = this.get(storageFullPath);
            value = this.getSpecificData(storedData, path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            value = null;
        }
        return value;
    }

    public Object getInputParamFromStorage(String jobId, String taskId, String path) {
        Object value;
        try {
            Object storedData = this.get(jobId, taskId);
            value = this.getSpecificData(storedData, path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            value = null;
        }
        return value;
    }

    public Object getSpecificData(Object storedData, String path) {
        Object value;
        if (path != null && path.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(path, ".");
            String relativePath = "";
            while (tokenizer.hasMoreElements()) {
                String nextToken = tokenizer.nextToken();
                if (StringUtils.isNumeric((CharSequence)nextToken)) {
                    nextToken = "[" + (Integer.valueOf(nextToken) + 1) + "]";
                    relativePath = relativePath + nextToken;
                    continue;
                }
                relativePath = relativePath + "/" + nextToken;
            }
            if ((storedData instanceof Map || storedData instanceof Collection) && relativePath.length() > 0) {
                if (relativePath.startsWith("[")) {
                    relativePath = "." + relativePath;
                }
                value = JXPathContext.newContext((Object)storedData).getValue(relativePath);
            } else {
                value = storedData;
            }
        } else {
            value = storedData;
        }
        return value;
    }
}

