/*
 * Decompiled with CFR 0.152.
 */
package hkube.algo.wrapper;

import hkube.algo.wrapper.StorageProxy;
import hkube.algo.wrapper.WrapperConfig;
import hkube.communication.BatchRequest;
import hkube.communication.IRequest;
import hkube.communication.SingleRequest;
import hkube.communication.zmq.ZMQRequest;
import hkube.encoding.EncodingManager;
import hkube.model.HeaderContentPair;
import hkube.model.ObjectAndSize;
import hkube.storage.IStorageConfig;
import hkube.storage.StorageFactory;
import hkube.storage.TaskStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataAdapter {
    WrapperConfig config;
    TaskStorage taskStorage;
    StorageProxy storageProxy;
    private static final Logger logger = LogManager.getLogger();

    public DataAdapter(WrapperConfig config) {
        this.config = config;
        this.taskStorage = new StorageFactory((IStorageConfig)config.storageConfig).getTaskStorage();
        this.storageProxy = new StorageProxy(this.taskStorage);
    }

    public Collection placeData(Map args) {
        Boolean useCache = (Boolean)args.get("useCache");
        Map storage = (Map)args.get("storage");
        HashMap results = new HashMap();
        Object flatInput = args.get("flatInput");
        if (flatInput instanceof Map && !((Map)flatInput).isEmpty()) {
            for (Map.Entry entry : ((Map)flatInput).entrySet()) {
                Object currentValue;
                Object value;
                String key = (String)entry.getKey();
                Object dataReference = entry.getValue();
                if (!(dataReference instanceof String) || !((String)dataReference).startsWith("$$")) {
                    value = dataReference;
                } else {
                    dataReference = ((String)dataReference).substring(2);
                    Object item = storage.get(dataReference);
                    String jobId = (String)args.get("jobId");
                    if (item instanceof List) {
                        Map batchInfp = (Map)((List)item).get(0);
                        if (batchInfp.get("tasks") != null) {
                            value = this.getData(batchInfp, jobId);
                        } else {
                            ArrayList arr = new ArrayList();
                            ((List)item).stream().forEach(info -> arr.add(this.getData((Map)info, jobId)));
                            value = arr;
                        }
                    } else {
                        value = this.getData((Map)item, jobId);
                    }
                }
                String[] keyParts = key.split("\\.");
                Object tempValue = currentValue = args.get("input");
                for (int i = 0; i < keyParts.length - 1; ++i) {
                    tempValue = StringUtils.isNumeric((CharSequence)keyParts[i]) ? ((List)tempValue).get(Integer.valueOf(keyParts[i])) : ((Map)tempValue).get(keyParts[i]);
                }
                String index = keyParts[keyParts.length - 1];
                if (StringUtils.isNumeric((CharSequence)keyParts[keyParts.length - 1])) {
                    ((ArrayList)tempValue).set(Integer.valueOf(index), value);
                    continue;
                }
                ((Map)tempValue).put(index, value);
            }
        }
        Collection originalInput = (Collection)args.get("input");
        Iterator iterator = originalInput.iterator();
        ArrayList inputList = new ArrayList();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            inputList.add(value);
        }
        return originalInput;
    }

    public Object getData(Map single, String jobId) {
        List value = null;
        String path = single.get("path") != null ? (String)single.get("path") : "";
        String task = null;
        List<String> tasks = null;
        if (single.get("discovery") != null) {
            Map discovery = (Map)single.get("discovery");
            String host = (String)discovery.get("host");
            String port = (String)discovery.get("port");
            ZMQRequest zmqr = new ZMQRequest(host, port, this.config.commConfig);
            SingleRequest singleRequest = null;
            BatchRequest batchRequest = null;
            if (single.get("tasks") != null) {
                tasks = DataAdapter.getStringListFromJSONArray((Collection)single.get("tasks"));
                batchRequest = new BatchRequest((IRequest)zmqr, tasks, this.config.commConfig.getEncodingType());
            } else {
                task = (String)single.get("taskId");
                singleRequest = new SingleRequest((IRequest)zmqr, task, this.config.commConfig.getEncodingType());
            }
            try {
                if (singleRequest != null) {
                    ObjectAndSize objectAndSize = (ObjectAndSize)singleRequest.send();
                    value = objectAndSize.getValue();
                    if (single.get("storageInfo") != null) {
                        Map storageInfo = (Map)single.get("storageInfo");
                        logger.info("Getting single task result from storage");
                        this.storageProxy.setToCache(storageInfo, (Object)value, objectAndSize.getSize());
                    }
                    value = this.storageProxy.getSpecificData(value, path);
                } else {
                    Map batchResult = batchRequest.send();
                    List resultValues = batchResult.entrySet().stream().map(result -> {
                        String taskId = (String)result.getKey();
                        Object currentValue = ((ObjectAndSize)result.getValue()).getValue();
                        this.storageProxy.setToCache(taskId, jobId, currentValue, ((ObjectAndSize)result.getValue()).getSize());
                        if (path != null && !path.equals("")) {
                            return this.storageProxy.getSpecificData(currentValue, path);
                        }
                        return currentValue;
                    }).collect(Collectors.toList());
                    List missingTasks = tasks.stream().filter(taskId -> !batchResult.containsKey(taskId)).collect(Collectors.toList());
                    logger.info("Got " + (tasks.size() - missingTasks.size()) + "valid task results from batch request");
                    value = missingTasks.stream().map(taskId -> this.storageProxy.getInputParamFromStorage(jobId, (String)taskId, path)).collect(Collectors.toList());
                    ((Collection)value).addAll(resultValues);
                }
            }
            catch (TimeoutException e) {
                logger.warn("Timeout trying to get output from " + host + ":" + port);
            }
            catch (Throwable e) {
                logger.warn("Exception getting data from peer : " + e.getMessage());
            }
        }
        if (value == null) {
            logger.info("value null getting from storage");
            if (single.get("storageInfo") != null) {
                Map storageInfo = (Map)single.get("storageInfo");
                logger.info("Getting single task result from storage");
                value = this.storageProxy.getInputParamFromStorage(storageInfo, path);
                logger.info("Got value from storage");
            } else if (single.get("tasks") != null) {
                tasks = DataAdapter.getStringListFromJSONArray((Collection)single.get("tasks"));
                logger.info("Getting result of batch from storage");
                value = tasks.stream().map(taskId -> this.storageProxy.getInputParamFromStorage(jobId, (String)taskId, path)).collect(Collectors.toList());
                logger.info("Got value from storage");
            }
        }
        return value;
    }

    public static Map getMetadata(Collection savePaths, Object result) {
        Iterator pathsIterator = savePaths.iterator();
        HashMap metadata = new HashMap();
        while (pathsIterator.hasNext()) {
            String path = (String)pathsIterator.next();
            StringTokenizer tokenizer = new StringTokenizer(path, ".");
            String relativePath = "";
            String nodeName = tokenizer.nextToken();
            while (tokenizer.hasMoreElements()) {
                String nextToken = tokenizer.nextToken();
                if (StringUtils.isNumeric((CharSequence)nextToken)) {
                    nextToken = "[" + (Integer.valueOf(nextToken) + 1) + "]";
                    relativePath = relativePath + nextToken;
                    continue;
                }
                relativePath = relativePath + "/" + nextToken;
            }
            try {
                String type;
                Object value = (result instanceof Map || result instanceof Collection) && relativePath.length() > 0 ? JXPathContext.newContext((Object)result).getValue(relativePath) : result;
                HashMap<String, Object> meta = new HashMap<String, Object>();
                if (value instanceof Integer || value instanceof Long || value instanceof Double) {
                    type = "number";
                } else if (value instanceof String) {
                    type = "string";
                } else if (value instanceof byte[]) {
                    type = "bytearray";
                    meta.put("size", ((byte[])value).length);
                } else if (value instanceof Collection) {
                    type = "array";
                    meta.put("size", ((Collection)value).size());
                } else {
                    type = "object";
                }
                meta.put("type", type);
                metadata.put(path, meta);
            }
            catch (Throwable e) {
                logger.warn("Problem while getting meta data for " + relativePath);
                logger.error(e.getMessage());
            }
        }
        return metadata;
    }

    HeaderContentPair encode(Object toBeEncoded, String encodingType) {
        HeaderContentPair encodedBytes = new EncodingManager(encodingType).encodeSeparately(toBeEncoded);
        return encodedBytes;
    }

    Map getStoringInfo(WrapperConfig config, String jobId, String taskId, Map metadata, int size) {
        HashMap<String, Object> wrappedResult = new HashMap<String, Object>();
        HashMap<String, Object> storageInfo = new HashMap<String, Object>();
        String fullPath = new StorageFactory((IStorageConfig)config.storageConfig).getTaskStorage().createFullPath(jobId, taskId);
        storageInfo.put("path", fullPath);
        storageInfo.put("size", size);
        wrappedResult.put("storageInfo", storageInfo);
        HashMap<String, String> discoveryComm = new HashMap<String, String>();
        discoveryComm.put("host", config.commConfig.getListeningHost());
        discoveryComm.put("port", config.commConfig.getListeningPort());
        wrappedResult.put("discovery", discoveryComm);
        wrappedResult.put("taskId", taskId);
        wrappedResult.put("metadata", metadata);
        return wrappedResult;
    }

    public static List<String> getStringListFromJSONArray(Collection array) {
        ArrayList<String> jsonObjects = new ArrayList<String>();
        Iterator iterator = array.iterator();
        while (iterator.hasNext()) {
            jsonObjects.add(iterator.next().toString());
        }
        return jsonObjects;
    }
}

