/*
 * Decompiled with CFR 0.152.
 */
package hkube.algo;

import hkube.algo.APIExecutionFuture;
import hkube.algo.CommandResponseListener;
import hkube.algo.ICommandSender;
import hkube.algo.wrapper.DataAdapter;
import hkube.api.IHKubeAPI;
import hkube.api.INode;
import hkube.utils.PrintUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HKubeAPIImpl
implements IHKubeAPI,
CommandResponseListener {
    private static final Logger logger = LogManager.getLogger();
    int lastExcution = 0;
    ICommandSender commandSender;
    Map<String, APIExecutionFuture> executions = new HashMap<String, APIExecutionFuture>();
    DataAdapter dataAdapter;

    public HKubeAPIImpl(ICommandSender sender, DataAdapter dataAdapter) {
        this.dataAdapter = dataAdapter;
        this.commandSender = sender;
        sender.addResponseListener(this);
    }

    public Future<Map> startAlgorithmAsynch(String name, List input, boolean resultAsRaw) {
        APIExecutionFuture future = new APIExecutionFuture();
        String executionId = this.getExecutionId(future);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("execId", executionId);
        data.put("algorithmName", name);
        data.put("input", input);
        data.put("resultAsRaw", resultAsRaw);
        this.commandSender.sendMessage("startAlgorithmExecution", data, false);
        return future;
    }

    public Map startAlgorithm(String name, List input, boolean resultAsRaw) {
        APIExecutionFuture future = (APIExecutionFuture)this.startAlgorithmAsynch(name, input, resultAsRaw);
        return this.returnWhenExecDone(future);
    }

    public Future<Map> startStoredPipeLineAsynch(String name, Map flowInput) {
        return this.startStoredPipeLineAsynch(name, flowInput, true);
    }

    public Future<Map> startStoredPipeLineAsynch(String name, Map flowInput, boolean includeResult) {
        APIExecutionFuture future = new APIExecutionFuture();
        String executionId = this.getExecutionId(future);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("subPipelineId", executionId);
        data.put("includeResult", includeResult);
        HashMap<String, Object> subPipeline = new HashMap<String, Object>();
        subPipeline.put("name", name);
        subPipeline.put("flowInput", flowInput);
        data.put("subPipeline", subPipeline);
        this.commandSender.sendMessage("startStoredSubPipeline", data, false);
        return future;
    }

    public Map startStoredPipeLine(String name, Map flowInput) {
        APIExecutionFuture future = (APIExecutionFuture)this.startStoredPipeLineAsynch(name, flowInput);
        return this.returnWhenExecDone(future);
    }

    public Map startStoredPipeLine(String name, Map flowInput, boolean includeResult) {
        APIExecutionFuture future = (APIExecutionFuture)this.startStoredPipeLineAsynch(name, flowInput, includeResult);
        return this.returnWhenExecDone(future);
    }

    public Future<Map> startRawSubPipeLineAsynch(String name, INode[] nodes, Map flowInput, Map options, Map webhooks) {
        APIExecutionFuture future = new APIExecutionFuture();
        String executionId = this.getExecutionId(future);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("subPipelineId", executionId);
        ArrayList nodesList = new ArrayList();
        Arrays.asList(nodes).forEach(node -> {
            HashMap<String, Object> nodeAttributes = new HashMap<String, Object>();
            nodeAttributes.put("nodeName", node.getName());
            nodeAttributes.put("algorithmName", node.getAlgorithmName());
            nodeAttributes.put("input", node.getInput());
            nodesList.add(nodeAttributes);
        });
        HashMap<String, Object> subPipeline = new HashMap<String, Object>();
        subPipeline.put("name", name);
        subPipeline.put("flowInput", flowInput);
        subPipeline.put("nodes", nodesList);
        subPipeline.put("options", options);
        subPipeline.put("webhooks", webhooks);
        data.put("subPipeline", subPipeline);
        this.commandSender.sendMessage("startRawSubPipeline", data, false);
        return future;
    }

    public Map startRawSubPipeLine(String name, INode[] nodes, Map flowInput, Map options, Map webhooks) {
        APIExecutionFuture future = (APIExecutionFuture)this.startRawSubPipeLineAsynch(name, nodes, flowInput, options, webhooks);
        return this.returnWhenExecDone(future);
    }

    String getExecutionId(APIExecutionFuture future) {
        String executionId = String.valueOf(++this.lastExcution);
        this.executions.put(executionId, future);
        return executionId;
    }

    Map returnWhenExecDone(APIExecutionFuture future) {
        while (!future.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onCommand(String command, Map data, boolean isDebug) {
        Object res;
        Map results;
        String executionId;
        String[] executionCommands = new String[]{"algorithmExecutionDone", "algorithmExecutionError"};
        String[] subPipeCommands = new String[]{"subPipelineDone", "subPipelineError", "subPipelineStopped"};
        logger.debug("got command" + command);
        if (data != null) {
            logger.debug(new PrintUtil().getAsJsonStr(data));
        } else {
            logger.debug("data null");
        }
        if (Arrays.asList(executionCommands).contains(command)) {
            executionId = (String)data.get("execId");
            if (!isDebug) {
                results = (Map)data.get("response");
                res = this.dataAdapter.getData(results, null);
                data.put("response", res);
            }
            this.executions.get(executionId).setResult(data);
        }
        if (Arrays.asList(subPipeCommands).contains(command)) {
            executionId = (String)data.get("subPipelineId");
            if (!isDebug) {
                results = (Map)data.get("response");
                res = "No results";
                if (results != null) {
                    res = this.dataAdapter.getData(results, null);
                }
                data.put("response", res);
            }
            this.executions.get(executionId).setResult(data);
        }
        logger.debug("Execution result" + data);
    }
}

