/*
 * Decompiled with CFR 0.152.
 */
package hkube.storage;

import hkube.storage.ISimplePathStorage;
import hkube.storage.IStorageConfig;
import hkube.storage.TaskStorage;
import java.lang.reflect.Method;

public class StorageFactory {
    TaskStorage taskStorage;
    ISimplePathStorage storage;
    IStorageConfig config;

    public StorageFactory(IStorageConfig config) {
        this.config = config;
        String type = config.getStorageType();
        String className = "hkube.storage." + type + "." + type.toUpperCase() + "Adapter";
        try {
            Class<?> claaz = this.getClass().getClassLoader().loadClass(className);
            Method method = claaz.getMethod("getInstance", new Class[0]);
            this.storage = (ISimplePathStorage)method.invoke(null, null);
            this.storage.setConfig(config);
            this.taskStorage = new TaskStorage(this.storage, config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TaskStorage getTaskStorage() {
        return this.taskStorage;
    }

    public ISimplePathStorage getStorage() {
        return this.storage;
    }

    public IStorageConfig getConfig() {
        return this.config;
    }
}

