/*
 * Decompiled with CFR 0.152.
 */
package hkube.storage;

import hkube.encoding.EncodingManager;
import hkube.encoding.IEncoder;
import hkube.model.HeaderContentPair;
import hkube.model.ObjectAndSize;
import hkube.storage.ISimplePathStorage;
import hkube.storage.IStorageConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

public abstract class BaseStorage {
    ISimplePathStorage adapter;
    IStorageConfig config;
    String rootName;
    IEncoder encoder;

    BaseStorage(ISimplePathStorage storage, IStorageConfig config) {
        this.adapter = storage;
        this.config = config;
        this.encoder = new EncodingManager(config.getEncodingType());
        this.rootName = config.getClusterName() + "-" + this.getRootPrefix();
    }

    void putEncoded(String path, HeaderContentPair data) {
        this.adapter.put(this.enhancePath(path), data);
    }

    ObjectAndSize get(String path) throws FileNotFoundException {
        HeaderContentPair encoded = this.adapter.get(this.enhancePath(path));
        Integer size = encoded.getContent().length;
        if (encoded.getHeader().isEncoded()) {
            Object value = this.encoder.decodeSeparately(encoded.getHeader(), encoded.getContent());
            return new ObjectAndSize(value, size);
        }
        byte[] value = encoded.getContent();
        return new ObjectAndSize((Object)value, size);
    }

    public ObjectAndSize getByFullPath(String path) throws FileNotFoundException {
        HeaderContentPair encoded = this.adapter.get(path);
        Integer size = encoded.getContent().length;
        Object value = encoded.getHeader() != null && encoded.getHeader().isEncoded() ? (Object)this.encoder.decodeNoHeader(encoded.getContent()) : encoded.getContent();
        return new ObjectAndSize(value, size);
    }

    List<String> list(String path) {
        return this.adapter.list(this.enhancePath(path));
    }

    void delete(String path) {
        this.adapter.delete(this.enhancePath(path));
    }

    String enhancePath(String path) {
        return this.rootName + File.separator + path;
    }

    abstract String getRootPrefix();
}

