/*
 * Decompiled with CFR 0.152.
 */
package hkube.storage.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import hkube.model.HeaderContentPair;
import hkube.storage.ISimplePathStorage;
import hkube.storage.IStorageConfig;
import hkube.storage.s3.IS3Config;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.StringTokenizer;

public class S3Adapter
implements ISimplePathStorage {
    AmazonS3 conn;

    public static ISimplePathStorage getInstance() {
        return new S3Adapter();
    }

    S3Adapter() {
    }

    public void init(String accessKey, String secretKey, String endPoint) {
        BasicAWSCredentials creds = new BasicAWSCredentials(accessKey, secretKey);
        this.conn = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)creds))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endPoint, Regions.DEFAULT_REGION.toString()))).build();
    }

    public void put(String path, HeaderContentPair data) {
        ByteArrayInputStream input = new ByteArrayInputStream(data.getContent());
        ObjectMetadata metadata = new ObjectMetadata();
        byte[] header = data.getHeaderAsBytes();
        if (header != null) {
            metadata.addUserMetadata("header", Base64.getEncoder().encodeToString(data.getHeaderAsBytes()));
        }
        this.conn.putObject(this.getBucket(path), this.getPathInBucket(path), (InputStream)input, new ObjectMetadata());
    }

    public HeaderContentPair get(String path) throws FileNotFoundException {
        try {
            S3Object objectInfo = this.conn.getObject(this.getBucket(path), this.getPathInBucket(path));
            ObjectMetadata metadata = objectInfo.getObjectMetadata();
            String headerAsString = metadata.getUserMetaDataOf("header");
            byte[] headerBytes = null;
            if (headerAsString != null) {
                headerBytes = Base64.getDecoder().decode(headerAsString);
            }
            S3ObjectInputStream inputStream = objectInfo.getObjectContent();
            byte[] tartgetArray = new byte[inputStream.available()];
            inputStream.read(tartgetArray);
            HeaderContentPair pair = new HeaderContentPair(headerBytes, tartgetArray);
            return pair;
        }
        catch (AmazonS3Exception e) {
            if (e.getMessage().contains("NoSuchKey")) {
                throw new FileNotFoundException(path);
            }
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> list(String path) {
        ObjectListing objects = this.conn.listObjects(this.getBucket(path), this.getPathInBucket(path));
        ArrayList<String> result = new ArrayList<String>();
        do {
            for (S3ObjectSummary objectSummary : objects.getObjectSummaries()) {
                result.add(objectSummary.getKey());
            }
        } while ((objects = this.conn.listNextBatchOfObjects(objects)).isTruncated());
        return result;
    }

    public void delete(String path) {
        this.conn.deleteObject(this.getBucket(path), this.getPathInBucket(path));
    }

    public void setConfig(IStorageConfig config) {
        IS3Config s3Config = (IS3Config)config.getTypeSpecificConfig();
        String accessKey = s3Config.getAccessKeyId();
        String secretKey = s3Config.getSecretAccessKey();
        String endPoint = s3Config.getS3EndPoint();
        this.init(accessKey, secretKey, endPoint);
    }

    String getBucket(String completePath) {
        StringTokenizer tokenizer = new StringTokenizer(completePath, "/");
        return tokenizer.nextToken();
    }

    String getPathInBucket(String completePath) {
        Object bucket = this.getBucket(completePath);
        if (completePath.startsWith("/")) {
            bucket = "/" + (String)bucket;
        }
        bucket = (String)bucket + "/";
        return completePath.replace((CharSequence)bucket, "");
    }
}

