/*
 * Decompiled with CFR 0.152.
 */
package hkube.storage.fs;

import hkube.model.Header;
import hkube.model.HeaderContentPair;
import hkube.storage.ISimplePathStorage;
import hkube.storage.IStorageConfig;
import hkube.storage.fs.IFSConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FSAdapter
implements ISimplePathStorage {
    File basePath;

    public static ISimplePathStorage getInstance() {
        return new FSAdapter();
    }

    public void put(String path, HeaderContentPair data) {
        File file = new File(this.basePath.getAbsoluteFile() + File.separator + path);
        File parentDir = new File(file.getParent());
        if (!parentDir.isDirectory()) {
            try {
                Files.createDirectories(Paths.get(parentDir.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory " + parentDir.getAbsolutePath());
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            byte[] header = data.getHeaderAsBytes();
            if (header != null) {
                fos.write(header);
            }
            fos.write(data.getContent());
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HeaderContentPair get(String path) throws FileNotFoundException {
        File file = new File(this.basePath.getAbsoluteFile() + File.separator + path);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath() + " does not exist");
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            String magicNumber;
            byte[] restOfHeader;
            int readBytes;
            byte[] versionAndSize = new byte[2];
            fis.read(versionAndSize);
            byte headerSize = versionAndSize[1];
            if (headerSize > 3 && (readBytes = fis.read(restOfHeader = new byte[headerSize - 2], 0, headerSize - 2)) >= headerSize - 2 && (magicNumber = new String(Arrays.copyOfRange(restOfHeader, restOfHeader.length - Header.MAGIC_NUMBER.length, restOfHeader.length))).equals(new String(Header.MAGIC_NUMBER))) {
                byte[] data = fis.readAllBytes();
                byte[] header = new byte[headerSize];
                System.arraycopy(versionAndSize, 0, header, 0, 2);
                System.arraycopy(restOfHeader, 0, header, 2, headerSize - 2);
                return new HeaderContentPair(header, data);
            }
            fis.close();
            fis = new FileInputStream(file);
            byte[] data = fis.readAllBytes();
            return new HeaderContentPair(null, data);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read" + file.getAbsolutePath());
        }
    }

    public void delete(String path) {
        File file = new File(this.basePath.getAbsoluteFile() + File.separator + path);
        file.delete();
    }

    public void setConfig(IStorageConfig config) {
        IFSConfig fsConfig = (IFSConfig)config.getTypeSpecificConfig();
        String basePathStr = fsConfig.getBaseDir();
        if (basePathStr != null) {
            this.basePath = new File(basePathStr);
            if (!this.basePath.isDirectory()) {
                this.basePath.mkdir();
            }
        } else {
            throw new RuntimeException("missing baseDirectory configuration parameter");
        }
    }

    public List<String> list(String path) {
        return this.listPrefix(path);
    }

    public List<String> listPrefix(String path) {
        List<String> list;
        block8: {
            Stream<Path> walk = Files.walk(Paths.get(this.basePath.getAbsoluteFile() + File.separator + path, new String[0]), new FileVisitOption[0]);
            try {
                List fullPathResult = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(x -> x.toString()).collect(Collectors.toList());
                list = fullPathResult.stream().map(fullPath -> fullPath.replace(this.basePath.getAbsolutePath(), "")).collect(Collectors.toList());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return list;
    }
}

