/*
 * Decompiled with CFR 0.152.
 */
package hkube.communication;

import hkube.communication.DataRequest;
import hkube.communication.IRequest;
import hkube.model.HeaderContentPair;
import hkube.model.ObjectAndSize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatchRequest
extends DataRequest {
    private static final Logger logger = LogManager.getLogger();

    public BatchRequest(IRequest requestAdapter, List tasks, String encoding) {
        super(requestAdapter, tasks, encoding);
    }

    @Override
    public Map<String, ObjectAndSize> send() throws TimeoutException {
        logger.info("Invoking batch from peer");
        HashMap<String, List> map = new HashMap<String, List>();
        if (this.tasks != null) {
            map.put("tasks", this.tasks);
        }
        List<HeaderContentPair> reply = this.requestAdapter.send(this.encoder.encodeNoHeader(map));
        ArrayList decodedList = new ArrayList();
        reply.stream().forEach(rep -> {
            Object decoded = this.encoder.decodeSeparately(rep.getHeader(), rep.getContent());
            ObjectAndSize objectAndSize = new ObjectAndSize(decoded, Integer.valueOf(rep.getContent().length));
            decodedList.add(objectAndSize);
        });
        if (logger.isDebugEnabled()) {
            Object result = this.toJSON(decodedList);
            logger.debug(result);
        }
        HashMap<String, ObjectAndSize> reslutMap = new HashMap<String, ObjectAndSize>();
        Iterator itemIterator = decodedList.iterator();
        int i = 0;
        while (itemIterator.hasNext()) {
            ObjectAndSize currentItem = (ObjectAndSize)itemIterator.next();
            Object currentValue = currentItem.getValue();
            if (currentValue instanceof Map && ((Map)currentValue).get("hkube_error") != null) continue;
            reslutMap.put((String)this.tasks.get(i), currentItem);
            ++i;
        }
        return reslutMap;
    }
}

