/*
 * Decompiled with CFR 0.152.
 */
package hkube.communication;

import hkube.communication.DataRequest;
import hkube.communication.IRequest;
import hkube.model.HeaderContentPair;
import hkube.model.ObjectAndSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class SingleRequest
extends DataRequest {
    private static final Logger logger = LogManager.getLogger();

    public SingleRequest(IRequest requestAdapter, String taskId, String encoding) {
        super(requestAdapter, null, encoding);
        ArrayList<String> tasks = new ArrayList<String>();
        tasks.add(taskId);
        this.tasks = tasks;
    }

    @Override
    public Object send() throws TimeoutException {
        Object result;
        logger.info("Invoking single from peer");
        HashMap<String, List> map = new HashMap<String, List>();
        if (this.tasks != null) {
            map.put("tasks", this.tasks);
        }
        List<HeaderContentPair> headerContentPairs = this.requestAdapter.send(this.encoder.encodeNoHeader(map));
        HeaderContentPair pair = headerContentPairs.get(0);
        Integer size = pair.getContent().length;
        HashMap decoded = this.encoder.decodeSeparately(pair.getHeader(), pair.getContent());
        if (logger.isDebugEnabled()) {
            result = this.toJSON(decoded);
            logger.debug(result);
        }
        if (decoded instanceof Map) {
            result = decoded;
            if (result.get("hkube_error") != null) {
                logger.warn(result.toString());
                throw new RuntimeException(result.toString());
            }
            if (this.tasks != null && result.get("errors") != null && ((Boolean)result.get("errors")).booleanValue() && result.get("items") != null) {
                Collection items = (Collection)result.get("items");
                Iterator itemIterator = items.iterator();
                HashMap listResult = new HashMap();
                int i = 0;
                while (itemIterator.hasNext()) {
                    Object currentItem = itemIterator.next();
                    if (!(currentItem instanceof JSONObject) || ((JSONObject)currentItem).has("hkube_error")) continue;
                    listResult.put(this.tasks.get(i), currentItem);
                }
                decoded = listResult;
            }
        }
        result = new ObjectAndSize((Object)decoded, size);
        return result;
    }
}

