/*
 * Decompiled with CFR 0.152.
 */
package hkube.communication;

import hkube.caching.EncodedCache;
import hkube.communication.ICommConfig;
import hkube.communication.IRequestListener;
import hkube.communication.IRequestServer;
import hkube.encoding.EncodingManager;
import hkube.encoding.IEncoder;
import hkube.model.HeaderContentPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class DataServer
implements IRequestListener {
    private static final Logger logger = LogManager.getLogger();
    IRequestServer communication;
    IEncoder encoder;
    HeaderContentPair notAvailableError;
    EncodedCache dataCache = new EncodedCache();
    ICommConfig conf;

    public DataServer(IRequestServer communication, ICommConfig conf) {
        communication.addRequestsListener(this);
        this.encoder = new EncodingManager(conf.getEncodingType());
        this.notAvailableError = this.encoder.encodeSeparately((Object)this.createError("notAvailable", "taskId notAvailable").toMap());
        this.communication = communication;
        this.conf = conf;
    }

    public boolean addTaskData(String taskId, HeaderContentPair data) {
        return this.dataCache.put(taskId, (Object)data, Integer.valueOf(data.getContent().length)) != null;
    }

    @Override
    public void onRequest(byte[] request) {
        try {
            List tasks;
            logger.debug("Got Request");
            Map requestInfo = (Map)this.encoder.decodeNoHeader(request);
            if (logger.isDebugEnabled()) {
                logger.debug("Got request " + new JSONObject(requestInfo));
            }
            if ((tasks = (List)requestInfo.get("tasks")) == null) {
                HeaderContentPair encodedError = this.encoder.encodeSeparately((Object)this.createError("unknown", "Request must contain either task or tasks attribute"));
                ArrayList<HeaderContentPair> reply = new ArrayList<HeaderContentPair>();
                reply.add(new HeaderContentPair(encodedError.getHeaderAsBytes(), encodedError.getContent()));
                this.communication.reply(reply);
            } else {
                List items = tasks.stream().map(task -> this.getResult((String)task)).collect(Collectors.toList());
                List<HeaderContentPair> reply = items.stream().map(item -> new HeaderContentPair(item.getHeaderAsBytes(), item.getContent())).collect(Collectors.toList());
                if (logger.isDebugEnabled()) {
                    logger.debug("Responding " + reply);
                }
                this.communication.reply(reply);
            }
        }
        catch (Throwable e) {
            ArrayList<HeaderContentPair> reply = new ArrayList<HeaderContentPair>();
            HeaderContentPair encodedError = this.encoder.encodeSeparately((Object)this.createError("unknown", "Unexpected error " + e.getMessage()));
            reply.add(new HeaderContentPair(encodedError.getHeaderAsBytes(), encodedError.getContent()));
            logger.warn("Data server responding:" + reply);
            this.communication.reply(reply);
        }
    }

    private HeaderContentPair getResult(String taskId) {
        HeaderContentPair data = (HeaderContentPair)this.dataCache.get(taskId);
        if (data == null) {
            data = this.notAvailableError;
        }
        return data;
    }

    private Object getSpecificData(Object storedData, String path) {
        Object value;
        if (path.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(path, ".");
            Object relativePath = "";
            while (tokenizer.hasMoreElements()) {
                Object nextToken = tokenizer.nextToken();
                if (StringUtils.isNumeric((CharSequence)nextToken)) {
                    nextToken = "[" + (Integer.valueOf((String)nextToken) + 1) + "]";
                    relativePath = (String)relativePath + (String)nextToken;
                    continue;
                }
                relativePath = (String)relativePath + "/" + (String)nextToken;
            }
            if ((storedData instanceof Map || storedData instanceof Collection) && ((String)relativePath).length() > 0) {
                if (((String)relativePath).startsWith("[")) {
                    relativePath = "." + (String)relativePath;
                }
                value = JXPathContext.newContext((Object)storedData).getValue((String)relativePath);
            } else {
                value = storedData;
            }
        } else {
            value = storedData;
        }
        return value;
    }

    private JSONObject createError(String code, String message) {
        JSONObject hkubeError = new JSONObject();
        hkubeError.put("code", (Object)code);
        hkubeError.put("message", (Object)message);
        JSONObject result = new JSONObject();
        result.put("hkube_error", (Object)hkubeError);
        return result;
    }

    public void close() {
        this.communication.close();
    }
}

