/*
 * Decompiled with CFR 0.152.
 */
package hkube.model;

import hkube.model.Header;
import java.util.Arrays;

public class HeaderContentPair {
    static final char[] MAGIC_NUMBER = new char[]{'H', 'K'};
    byte[] header;
    byte[] content;

    public Header getHeader() {
        if (this.header != null) {
            return HeaderContentPair.getHeader(this.header);
        }
        return null;
    }

    public byte[] getHeaderAsBytes() {
        return this.header;
    }

    public byte[] getContent() {
        return this.content;
    }

    public HeaderContentPair(byte[] header, byte[] content) {
        this.header = header;
        this.content = content;
    }

    public static Header getHeader(byte[] data) {
        byte headerEnd = data[1];
        if (headerEnd > data.length || headerEnd < 1) {
            return null;
        }
        byte[] headerBytes = Arrays.copyOfRange(data, 0, (int)headerEnd);
        String magicNumber = new String(Arrays.copyOfRange(headerBytes, headerBytes.length - MAGIC_NUMBER.length, headerBytes.length));
        if (!magicNumber.equals(new String(MAGIC_NUMBER))) {
            return null;
        }
        Header header = new Header(headerBytes);
        return header;
    }
}

