/*
 * Decompiled with CFR 0.152.
 */
package hkube.caching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Cache<T> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    static Long sizeLimit = null;
    static Long accumulatingSize = null;
    static Map<String, CacheItem> db = new HashMap<String, CacheItem>();

    public static void init(Integer cacheLimit) {
        sizeLimit = Long.valueOf(cacheLimit.intValue()) * 1000L * 1000L;
        db = new HashMap<String, CacheItem>();
        accumulatingSize = 0L;
    }

    public T get(String key) {
        CacheItem item = db.get(key);
        if (item != null) {
            return (T)item.getValue();
        }
        return null;
    }

    public String put(String key, T value, Integer size) {
        if ((long)size.intValue() > sizeLimit) {
            this.logger.warn("Trying to insert a value of size " + size + " larger than " + sizeLimit);
            return null;
        }
        while ((long)size.intValue() + accumulatingSize > sizeLimit) {
            this.removeOldest();
        }
        CacheItem item = this.createItem(key, value, size);
        db.put(key, item);
        accumulatingSize = accumulatingSize + Long.valueOf(size.intValue());
        return key;
    }

    abstract CacheItem createItem(String var1, T var2, Integer var3);

    private void removeOldest() {
        Iterator<CacheItem> iterator = db.values().iterator();
        CacheItem oldestItem = null;
        while (iterator.hasNext()) {
            CacheItem next = iterator.next();
            if (oldestItem == null) {
                oldestItem = next;
            }
            if (oldestItem.getTime() <= next.getTime()) continue;
            oldestItem = next;
        }
        db.remove(oldestItem.getKey());
        accumulatingSize = accumulatingSize - Long.valueOf(oldestItem.getSize().intValue());
    }

    public Integer getNumberOfItems() {
        return db.size();
    }

    static interface CacheItem {
        public Object getValue();

        public String getKey();

        public Long getTime();

        public Integer getSize();
    }
}

