/*
 * Decompiled with CFR 0.152.
 */
package hkube.utils;

import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private final Logger logger = LogManager.getLogger(this.getClass());
    Properties configs = new Properties();

    public Config() {
        try {
            this.configs.load(this.getClass().getClassLoader().getResourceAsStream("config.properties"));
        }
        catch (Throwable e) {
            this.logger.info("no config in classpath");
        }
    }

    protected String getStrEnvValue(String name, String defaultValue) {
        String value = this.getValue(name);
        if (value == null) {
            if (defaultValue == null) {
                throw new RuntimeException("Missing environment parameter " + name);
            }
            return defaultValue;
        }
        return value;
    }

    protected Integer getNumericEnvValue(String name, Integer defaultValue) {
        String value = this.getValue(name);
        if (value == null) {
            if (defaultValue == null) {
                throw new RuntimeException("Missing environment parameter " + name);
            }
            return defaultValue;
        }
        Integer asIntValue = Integer.valueOf(value);
        return asIntValue;
    }

    private String getValue(String name) {
        String value = (String)this.configs.get(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }
}

