/*
 * Decompiled with CFR 0.152.
 */
package io.hgc.jarspec;

import io.hgc.jarspec.Test;
import io.hgc.jarspec.Util;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class SpecificationNode {
    private final boolean solo;

    private SpecificationNode(boolean solo) {
        this.solo = solo;
    }

    public SpecificationNode skip() {
        return SpecificationNode.statement(this.description(), Optional.empty());
    }

    public abstract SpecificationNode only();

    abstract String description();

    abstract Optional<Test> test();

    abstract List<SpecificationNode> children();

    boolean isSolo() {
        return this.solo;
    }

    static SpecificationNode describe(String unit, List<SpecificationNode> children) {
        return new Aggregate(unit, Util.immutableCopyOf(children), false);
    }

    static SpecificationNode statement(String behaviour, Optional<Test> test) {
        return new Statement(behaviour, test, false);
    }

    static SpecificationNode error(String description, Throwable throwable) {
        return SpecificationNode.statement(description, Optional.of(() -> {
            throw Util.exceptionFrom(throwable);
        }));
    }

    private static class Statement
    extends SpecificationNode {
        private final String behaviour;
        private final Optional<Test> test;

        private Statement(String behaviour, Optional<Test> test, boolean solo) {
            super(solo);
            this.behaviour = behaviour;
            this.test = test;
        }

        @Override
        public SpecificationNode only() {
            return new Statement(this.behaviour, this.test, true);
        }

        @Override
        Optional<Test> test() {
            return this.test;
        }

        @Override
        String description() {
            return this.behaviour;
        }

        @Override
        List<SpecificationNode> children() {
            return Collections.emptyList();
        }
    }

    private static class Aggregate
    extends SpecificationNode {
        private final String unit;
        private final List<SpecificationNode> children;

        private Aggregate(String unit, List<SpecificationNode> children, boolean solo) {
            super(solo);
            this.unit = unit;
            this.children = children;
        }

        @Override
        public SpecificationNode only() {
            return new Aggregate(this.unit, this.children, true);
        }

        @Override
        Optional<Test> test() {
            return Optional.empty();
        }

        @Override
        String description() {
            return this.unit;
        }

        @Override
        List<SpecificationNode> children() {
            return this.children;
        }
    }
}

