/*
 * Decompiled with CFR 0.152.
 */
package io.hgc.jarspec;

import io.hgc.jarspec.ByMultiple;
import io.hgc.jarspec.BySingle;
import io.hgc.jarspec.SpecificationNode;
import io.hgc.jarspec.Test;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface Specification {
    public SpecificationNode root();

    default public SpecificationNode describe(String unit, BySingle specification) {
        try {
            return SpecificationNode.describe(unit, this.by(specification.get()));
        }
        catch (Throwable e) {
            return SpecificationNode.error(unit, e);
        }
    }

    default public SpecificationNode describe(String unit, ByMultiple specifications) {
        try {
            return SpecificationNode.describe(unit, specifications.get());
        }
        catch (Throwable e) {
            return SpecificationNode.error(unit, e);
        }
    }

    default public SpecificationNode it(String statement, Test test) {
        return SpecificationNode.statement(statement, Optional.of(test));
    }

    default public SpecificationNode it(String statement) {
        return SpecificationNode.statement(statement, Optional.empty());
    }

    default public List<SpecificationNode> by(SpecificationNode ... specificationNodes) {
        ArrayList<SpecificationNode> list = new ArrayList<SpecificationNode>();
        Collections.addAll(list, specificationNodes);
        return list;
    }
}

