/*
 * Decompiled with CFR 0.152.
 */
package io.hgc.jarspec;

import io.hgc.jarspec.Specification;
import io.hgc.jarspec.SpecificationNode;
import io.hgc.jarspec.Test;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JarSpecJUnitRunner<T extends Specification>
extends Runner {
    private final Class<T> specClass;
    private final Map<Description, Optional<Test>> allTests;
    private final Set<Description> soloTests;
    private final Description topLevelDescription;

    public JarSpecJUnitRunner(Class<T> specClass) throws InstantiationException {
        this.specClass = specClass;
        try {
            this.allTests = new LinkedHashMap<Description, Optional<Test>>();
            this.soloTests = new HashSet<Description>();
            this.topLevelDescription = this.visitTree(((Specification)specClass.newInstance()).root());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Description getDescription() {
        return this.topLevelDescription;
    }

    public void run(RunNotifier notifier) {
        this.allTests.forEach((description, test) -> {
            boolean included;
            boolean bl = included = this.soloTests.isEmpty() || this.soloTests.contains(description);
            if (included && test.isPresent()) {
                this.runTest((Description)description, (Test)test.get(), notifier);
            } else {
                notifier.fireTestIgnored(description);
            }
        });
    }

    private Description visitTree(SpecificationNode specificationNode) {
        Description description = Description.createTestDescription(this.specClass, (String)specificationNode.description());
        this.visitTree(specificationNode, "", specificationNode.isSolo()).forEach(arg_0 -> ((Description)description).addChild(arg_0));
        return description;
    }

    private List<Description> visitTree(SpecificationNode specificationNode, String prefix, boolean soloParent) {
        boolean isSolo;
        ArrayList<Description> descriptions = new ArrayList<Description>();
        String text = prefix + specificationNode.description();
        Description description = Description.createTestDescription(this.specClass, (String)text);
        boolean bl = isSolo = soloParent || specificationNode.isSolo();
        if (specificationNode.test().isPresent() || specificationNode.children().isEmpty()) {
            descriptions.add(description);
            this.allTests.put(description, specificationNode.test());
            if (isSolo) {
                this.soloTests.add(description);
            }
        }
        if (!specificationNode.children().isEmpty()) {
            for (SpecificationNode child : specificationNode.children()) {
                descriptions.addAll(this.visitTree(child, text + " ", isSolo));
            }
        }
        return descriptions;
    }

    private void runTest(Description description, Test test, RunNotifier notifier) {
        try {
            notifier.fireTestStarted(description);
            test.run();
        }
        catch (AssumptionViolatedException e) {
            notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)e));
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(description, e));
        }
        notifier.fireTestFinished(description);
    }
}

