/*
 * Decompiled with CFR 0.152.
 */
package io.hgc.jarspec;

import io.hgc.jarspec.Test;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class SpecificationNode {
    private SpecificationNode() {
    }

    abstract Optional<Test> test();

    abstract String description();

    abstract List<SpecificationNode> children();

    static class SpecError
    extends SpecificationNode {
        private final String unit;
        private final Exception exception;

        public SpecError(String unit, Throwable throwable) {
            this.unit = unit;
            this.exception = throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable);
        }

        @Override
        Optional<Test> test() {
            return Optional.of(() -> {
                throw this.exception;
            });
        }

        @Override
        String description() {
            return this.unit;
        }

        @Override
        List<SpecificationNode> children() {
            return Collections.emptyList();
        }
    }

    static class Statement
    extends SpecificationNode {
        private String behaviour;
        private Test test;

        public Statement(String behaviour, Test test) {
            this.behaviour = behaviour;
            this.test = test;
        }

        @Override
        Optional<Test> test() {
            return Optional.of(this.test);
        }

        @Override
        String description() {
            return this.behaviour;
        }

        @Override
        List<SpecificationNode> children() {
            return Collections.emptyList();
        }
    }

    static class Aggregate
    extends SpecificationNode {
        private String unit;
        private List<SpecificationNode> children;

        public Aggregate(String unit, List<SpecificationNode> children) {
            this.unit = unit;
            this.children = children;
        }

        @Override
        Optional<Test> test() {
            return Optional.empty();
        }

        @Override
        String description() {
            return this.unit;
        }

        @Override
        List<SpecificationNode> children() {
            return this.children;
        }
    }
}

