/*
 * Decompiled with CFR 0.152.
 */
package io.hgc.jarspec;

import io.hgc.jarspec.Specification;
import io.hgc.jarspec.SpecificationNode;
import io.hgc.jarspec.Test;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JarSpecJUnitRunner<T extends Specification>
extends Runner {
    private Class<T> specClass;
    private SpecificationNode rootSpecification;

    public JarSpecJUnitRunner(Class<T> specClass) throws InstantiationException {
        this.specClass = specClass;
        try {
            Specification specification = (Specification)specClass.newInstance();
            this.rootSpecification = specification.root();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Description getDescription() {
        return this.visitTree(this.rootSpecification, Optional.empty());
    }

    public void run(RunNotifier notifier) {
        this.visitTree(this.rootSpecification, Optional.of(notifier));
    }

    private Description visitTree(SpecificationNode specificationNode, Optional<RunNotifier> notifier) {
        Description description = Description.createTestDescription(this.specClass, (String)specificationNode.description());
        this.visitTree(this.rootSpecification, notifier, "").forEach(arg_0 -> ((Description)description).addChild(arg_0));
        return description;
    }

    private List<Description> visitTree(SpecificationNode specificationNode, Optional<RunNotifier> notifier, String prefix) {
        String text = prefix + specificationNode.description();
        ArrayList<Description> descriptions = new ArrayList<Description>();
        if (specificationNode.test().isPresent()) {
            Description description = Description.createTestDescription(this.specClass, (String)text);
            descriptions.add(description);
            if (notifier.isPresent()) {
                this.runTest(specificationNode.test().get(), notifier.get(), description);
            }
        }
        if (specificationNode.children().size() > 0) {
            for (SpecificationNode child : specificationNode.children()) {
                descriptions.addAll(this.visitTree(child, notifier, text + " "));
            }
        }
        return descriptions;
    }

    private void runTest(Test test, RunNotifier notifier, Description description) {
        try {
            notifier.fireTestStarted(description);
            test.run();
        }
        catch (AssumptionViolatedException e) {
            notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)e));
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(description, e));
        }
        notifier.fireTestFinished(description);
    }
}

