/*
 * Decompiled with CFR 0.152.
 */
package io.herrera.kevin.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class Reflect {
    private Class<?> clazz;
    private Object object;

    private Reflect(Class<?> clazz) {
        this.clazz = clazz;
    }

    private Reflect(Object object) {
        this(object.getClass());
        this.object = object;
    }

    public Method anyMethod(String name) {
        return Reflect.findAnyMethod(this.clazz, name);
    }

    public Field field(String name) {
        return Reflect.findField(this.clazz, name);
    }

    public static Method findAnyMethod(Class<?> clazz, String name) {
        Objects.requireNonNull(clazz, "The class is required.");
        Objects.requireNonNull(name, "The method name is required.");
        Method[] methods = (Method[])Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getName().equals(name)).toArray(Method[]::new);
        if (methods.length > 0) {
            return Reflect.makeAccessible(methods[0]);
        }
        if (clazz.getSuperclass() != null) {
            return Reflect.findAnyMethod(clazz.getSuperclass(), name);
        }
        throw new NoSuchMethodException(String.format("%s.%s()", clazz.getName(), name));
    }

    public static Method findAnyMethod(Object object, String name) {
        Objects.requireNonNull(object, "The object is required.");
        return Reflect.findAnyMethod(object.getClass(), name);
    }

    public static Field findField(Class<?> clazz, String name) {
        Objects.requireNonNull(clazz, "The class is required.");
        Objects.requireNonNull(name, "The field name is required.");
        try {
            return Reflect.makeAccessible(clazz.getDeclaredField(name));
        }
        catch (NoSuchFieldException cause) {
            if (clazz.getSuperclass() != null) {
                return Reflect.findField(clazz.getSuperclass(), name);
            }
            throw cause;
        }
    }

    public static Field findField(Object object, String name) {
        Objects.requireNonNull(object, "The object is required.");
        return Reflect.findField(object.getClass(), name);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Objects.requireNonNull(clazz, "The class is required.");
        Objects.requireNonNull(name, "The method name is required.");
        try {
            return Reflect.makeAccessible(clazz.getDeclaredMethod(name, parameterTypes));
        }
        catch (NoSuchMethodException cause) {
            if (clazz.getSuperclass() != null) {
                return Reflect.findMethod(clazz.getSuperclass(), name, parameterTypes);
            }
            throw cause;
        }
    }

    public static Method findMethod(Object object, String name, Class<?> ... parameterTypes) {
        Objects.requireNonNull(object, "The object is required.");
        return Reflect.findMethod(object.getClass(), name, parameterTypes);
    }

    public <T> T get(String name) {
        return (T)Reflect.findField(this.clazz, name).get(this.object);
    }

    public static <T> T getFieldValue(Class<?> clazz, String name) {
        return (T)Reflect.findField(clazz, name).get(null);
    }

    public static <T> T getFieldValue(Object object, String name) {
        return (T)Reflect.findField(object, name).get(object);
    }

    public <T> T invoke(String name, Object ... arguments) {
        return Reflect.invokeMethod(this.clazz, this.object, name, arguments);
    }

    public <T> T invokeAny(String name, Object ... arguments) {
        return Reflect.invokeAnyMethod(this.clazz, this.object, name, arguments);
    }

    private static <T> T invokeAnyMethod(Class<?> clazz, Object object, String name, Object ... arguments) {
        try {
            return (T)Reflect.findAnyMethod(clazz, name).invoke(object, arguments);
        }
        catch (InvocationTargetException cause) {
            throw cause.getCause();
        }
    }

    public static <T> T invokeAnyMethod(Class<?> clazz, String name, Object ... arguments) {
        return Reflect.invokeAnyMethod(clazz, null, name, arguments);
    }

    public static <T> T invokeAnyMethod(Object object, String name, Object ... arguments) {
        return Reflect.invokeMethod(object.getClass(), object, name, arguments);
    }

    private static <T> T invokeMethod(Class<?> clazz, Object object, String name, Object ... arguments) {
        Method method = Reflect.findMethod(clazz, name, (Class[])Arrays.stream(arguments).map(Object::getClass).toArray(Class[]::new));
        try {
            return (T)method.invoke(object, arguments);
        }
        catch (InvocationTargetException cause) {
            throw cause.getCause();
        }
    }

    public static <T> T invokeMethod(Class<?> clazz, String name, Object ... arguments) {
        return Reflect.invokeMethod(clazz, null, name, arguments);
    }

    public static <T> T invokeMethod(Object object, String name, Object ... arguments) {
        return Reflect.invokeMethod(object.getClass(), object, name, arguments);
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        object.setAccessible(true);
        return object;
    }

    public Method method(String name, Class<?> ... parameterTypes) {
        return Reflect.findMethod(this.clazz, name, parameterTypes);
    }

    public static Reflect on(Class<?> clazz) {
        return new Reflect(clazz);
    }

    public static Reflect on(Object object) {
        return new Reflect(object);
    }

    public <T> void set(String name, T value) {
        Reflect.findField(this.clazz, name).set(this.object, value);
    }

    public static <T> void setFieldValue(Class<?> clazz, String name, T value) {
        Reflect.findField(clazz, name).set(null, value);
    }

    public static <T> void setFieldValue(Object object, String name, T value) {
        Reflect.findField(object, name).set(object, value);
    }
}

