/*
 * Decompiled with CFR 0.152.
 */
package io.herrera.kevin.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class Reflect {
    public static Field findField(Class<?> clazz, String name) {
        Objects.requireNonNull(clazz, "The class is required.");
        Objects.requireNonNull(name, "The field name is required.");
        NoSuchFieldException exception = null;
        while (true) {
            try {
                return Reflect.makeAccessible(clazz.getDeclaredField(name));
            }
            catch (NoSuchFieldException cause) {
                if (exception != null) continue;
                exception = cause;
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw exception;
            }
            break;
        }
    }

    public static Field findField(Object object, String name) {
        Objects.requireNonNull(object, "The object is required.");
        return Reflect.findField(object.getClass(), name);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Objects.requireNonNull(clazz, "The class is required.");
        Objects.requireNonNull(name, "The method name is required.");
        NoSuchMethodException exception = null;
        while (true) {
            try {
                return Reflect.makeAccessible(clazz.getDeclaredMethod(name, parameterTypes));
            }
            catch (NoSuchMethodException cause) {
                if (exception != null) continue;
                exception = cause;
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw exception;
            }
            break;
        }
    }

    public static Method findMethod(Object object, String name, Class<?> ... parameterTypes) {
        Objects.requireNonNull(object, "The object is required.");
        return Reflect.findMethod(object.getClass(), name, parameterTypes);
    }

    public static <T> T getFieldValue(Class<?> clazz, String name) {
        return (T)Reflect.findField(clazz, name).get(null);
    }

    public static <T> T getFieldValue(Object object, String name) {
        return (T)Reflect.findField(object, name).get(object);
    }

    private static <T> T invokeMethod(Class<?> clazz, Object object, String name, Object ... arguments) {
        Method method = Reflect.findMethod(clazz, name, (Class[])Arrays.stream(arguments).map(Object::getClass).toArray(Class[]::new));
        try {
            return (T)method.invoke(object, arguments);
        }
        catch (InvocationTargetException cause) {
            throw cause.getCause();
        }
    }

    public static <T> T invokeMethod(Class<?> clazz, String name, Object ... arguments) {
        return Reflect.invokeMethod(clazz, null, name, arguments);
    }

    public static <T> T invokeMethod(Object object, String name, Object ... arguments) {
        return Reflect.invokeMethod(object.getClass(), object, name, arguments);
    }

    public static <T> void setFieldValue(Class<?> clazz, String name, T value) {
        Reflect.findField(clazz, name).set(null, value);
    }

    public static <T> void setFieldValue(Object object, String name, T value) {
        Reflect.findField(object, name).set(object, value);
    }

    private Reflect() {
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        object.setAccessible(true);
        return object;
    }
}

