/*
 * Decompiled with CFR 0.152.
 */
package io.gupshup.maven;

import io.gupshup.maven.Run;
import io.gupshup.maven.utils.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.server.Server;
import org.json.JSONObject;

class TCPTunnel
implements Runnable {
    private Thread tunnelThread;
    private AtomicBoolean keepRunning;
    private int tunnelServerPort = -1;
    private int destinationPort = -1;
    private String tunnelUrl = "";
    private Socket tunnelServerSocket;
    private Socket botServerSocket;

    TCPTunnel() {
    }

    private void getPort(String apiKey, String botName) throws InterruptedException {
        try {
            System.out.println("[INFO] Attempting to start bot.");
            this.tunnelServerPort = -1;
            URL url = new URL("https://localtunnel.me/?new");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setConnectTimeout(30000);
            con.setReadTimeout(30000);
            JSONObject resp = new JSONObject(HttpUtils.convertStreamToString(con.getInputStream()));
            this.tunnelUrl = resp.getString("url");
            this.tunnelServerPort = resp.getInt("port");
            Run.setCallback(apiKey, botName, this.tunnelUrl + "/botcallback");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InterruptedException("[ERROR] Unable to start bot.");
        }
    }

    public void startTunnel(String apiKey, String botName, int port) throws InterruptedException {
        this.destinationPort = port;
        this.keepRunning = new AtomicBoolean(true);
        this.getPort(apiKey, botName);
        while (this.keepRunning.get()) {
            try {
                this.tunnelServerSocket = new Socket("localtunnel.me", this.tunnelServerPort);
            }
            catch (IOException e) {
                this.getPort(apiKey, botName);
                continue;
            }
            this.tunnelThread = new Thread(this);
            this.tunnelThread.start();
            this.tunnelThread.join();
        }
        System.out.println("[INFO] Exiting from tunnel.");
    }

    public void stopTunnel(Server server) {
        if (this.keepRunning != null) {
            this.keepRunning.set(false);
        }
        try {
            server.stop();
        }
        catch (Exception e) {
            System.err.println("[ERROR] Exception in stopping bot server.");
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        OutputStream botServerOut;
        InputStream botServerIn;
        OutputStream tunnelServerOut;
        InputStream tunnelServerIn;
        try {
            this.botServerSocket = new Socket("localhost", this.destinationPort);
            this.botServerSocket.setKeepAlive(true);
            this.tunnelServerSocket.setKeepAlive(true);
            tunnelServerIn = this.tunnelServerSocket.getInputStream();
            tunnelServerOut = this.tunnelServerSocket.getOutputStream();
            botServerIn = this.botServerSocket.getInputStream();
            botServerOut = this.botServerSocket.getOutputStream();
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Bot Server is not started.");
            this.connectionBroken();
            return;
        }
        ForwardThread tunnelServerForward = new ForwardThread(tunnelServerIn, botServerOut);
        tunnelServerForward.start();
        ForwardThread botServerForward = new ForwardThread(botServerIn, tunnelServerOut);
        botServerForward.start();
        try {
            tunnelServerForward.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            botServerForward.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void connectionBroken() {
        try {
            this.tunnelServerSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.botServerSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class ForwardThread
    extends Thread {
        private static final int BUFFER_SIZE = 8192;
        InputStream mInputStream;
        OutputStream mOutputStream;

        public ForwardThread(InputStream aInputStream, OutputStream aOutputStream) {
            this.mInputStream = aInputStream;
            this.mOutputStream = aOutputStream;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[8192];
            try {
                int bytesRead;
                while ((bytesRead = this.mInputStream.read(buffer)) != -1) {
                    this.mOutputStream.write(buffer, 0, bytesRead);
                    this.mOutputStream.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TCPTunnel.this.connectionBroken();
        }
    }
}

