/*
 * Copyright 2017 Gupshup.io. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gupshup.maven.utils;

import java.io.IOException;
import java.util.Properties;

/**
 * @author Abhishek
 */
public class Constants {
    private static Properties CONFIG = null;

    static {
	try {
	    CONFIG = new Properties();
	    CONFIG.load(Constants.class.getClassLoader().getResourceAsStream("config.properties"));
	} catch (IOException e) {
	    e.printStackTrace();
	}
    }

    public static final String BOT_CLASS = "gupshup.bot.class";
    public static final String BOT_NAME = "gupshup.bot.name";
    public static final String GS_APIKEY = "gupshup.dev.apikey";

    public static final String BOT_PROPERTIES = "gsbot-cfg.properties";

    public static final class SMAPIConsts {
	public static final String CREATE_BOT = CONFIG.getProperty("sm_api.create_bot");
	public static final String GIT_CREATE = CONFIG.getProperty("sm_api.git_create");
	public static final String GIT_URL = CONFIG.getProperty("sm_api.git_url");
	public static final String GET_BOT_SPEC = CONFIG.getProperty("sm_api.get_bot_spec");
	public static final String GET_BOT_META = CONFIG.getProperty("sm_api.get_bot_meta");
	public static final String UPLOAD_JAVA_BOT = CONFIG.getProperty("sm_api.upload_java_bot");

	public static final String GET_USER_PROFILE = CONFIG.getProperty("sm_api.get_user_profile");
	public static final String GET_BOT_ENV_LIST = CONFIG.getProperty("sm_api.get_bot_env_list");
	public static final String SET_BOT_ENV_CALLBACK = CONFIG.getProperty("sm_api.set_bot_env_callback");
    }

    public static final class TCPTunnelConsts {
	public static final String DESTINATION_HOST = "localhost";
	public static final String DESTINATION_PORT = "8080";
	public static final String BOT_SERVLET_PATH = "/botcallback";

	public static final String LOCAL_TUNNEL_HOST = "localtunnel.me";
	public static final String LOCAL_TUNNEL_NEW = "https://localtunnel.me/?new";
    }
}