/*
 * Copyright 2017 Gupshup.io. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gupshup.maven;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;

import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.json.JSONObject;

import io.gupshup.maven.utils.Constants;
import io.gupshup.maven.utils.SMAPIWrapper;

/**
 * @author Abhishek Nama
 */
@Mojo(name = "deploy", threadSafe = true, defaultPhase = LifecyclePhase.DEPLOY, requiresDependencyResolution = ResolutionScope.COMPILE_PLUS_RUNTIME)
public class Deploy extends AbstractMojo {
    @Parameter(defaultValue = "${project}", readonly = true, required = true)
    private MavenProject project;

    @Override
    public void execute() throws MojoExecutionException {
	try {
	    File projectBuild = new File(
		    project.getBuild().getDirectory() + File.separator + project.getBuild().getFinalName() + ".jar");
	    if (!projectBuild.exists())
		throw new MojoExecutionException("Build the project first! e.g. clean package");

	    List<?> resources = project.getResources();
	    if (resources.size() < 1)
		throw new MojoExecutionException("Project resources not found.");

	    Resource resource = (Resource) resources.get(0);
	    File gsCfgPropsFile = new File(resource.getDirectory() + File.separator + Constants.BOT_PROPERTIES);
	    if (!gsCfgPropsFile.exists())
		throw new MojoExecutionException("gsbot-cfg.properties not found in src" + File.separator + "main"
			+ File.separator + "resources");

	    Properties gsCfgProps = new Properties();
	    gsCfgProps.load(new FileInputStream(gsCfgPropsFile));

	    String botName = gsCfgProps.getProperty("gupshup.bot.name").trim();
	    String apiKey = gsCfgProps.getProperty("gupshup.dev.apikey").trim();

	    if ((botName == null || botName.equals("")) || (apiKey == null || botName.equals("")))
		throw new MojoExecutionException("gsbot-cfg.properties ==> required configuration not found");

	    getLog().info("");
	    getLog().info("------------------------------------------------------------------------ ");
	    getLog().info("Deploying " + project.getName() + " " + project.getBuild().getFinalName());
	    getLog().info("------------------------------------------------------------------------ ");
	    getLog().info("");

	    getLog().info("Started Bot Deployment...");
	    getLog().info("");
	    JSONObject resp = SMAPIWrapper.uploadJavaBot(projectBuild, botName, apiKey);
	    if (resp.getInt("status") != 200)
		throw new MojoExecutionException("Deployment failed: " + resp.getString("body"));

	    getLog().info("Response body: " + resp.getString("body"));
	    getLog().info("");
	} catch (Exception e) {
	    throw new MojoExecutionException("", e);
	}
    }
}