/*
 * Decompiled with CFR 0.152.
 */
package io.gupshup.maven.utils;

import io.gupshup.maven.utils.Constants;
import io.gupshup.maven.utils.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SMAPIWrapper {
    public static JSONObject createBot(String apiKey, String botName, String description) throws ClientProtocolException, IOException {
        String url = Constants.SMAPIConsts.CREATE_BOT.replace("__BOTNAME", botName);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPut httpPut = new HttpPut(url);
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        formParams.add(new BasicNameValuePair("lang", "java"));
        if (description != null) {
            formParams.add(new BasicNameValuePair("description", description));
        }
        httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
        httpPut.setHeader("apikey", apiKey);
        httpPut.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try (CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httpPut);){
            JSONObject response = new JSONObject();
            response.put("status", resp.getStatusLine().getStatusCode());
            response.put("body", (Object)(resp.getEntity().getContent() == null ? "{}" : IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)"UTF-8")));
            JSONObject jSONObject = response;
            return jSONObject;
        }
    }

    public static String getUserId(String apiKey) {
        String baseUrl = Constants.SMAPIConsts.GET_USER_PROFILE.replace("__APIKEY", apiKey);
        String[] paramname = new String[]{};
        String[] paramvalues = new String[]{};
        String[] headername = new String[]{"apikey"};
        String[] headervals = new String[]{apiKey};
        try {
            JSONObject resp = new JSONObject(HttpUtils.makeGet(baseUrl, paramname, paramvalues, headername, headervals));
            return resp.getString("userid");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDevId(String apiKey, String userId, String botName) {
        String baseUrl = Constants.SMAPIConsts.GET_BOT_ENV_LIST.replace("__USERID", userId).replace("__BOTNAME", botName);
        String[] paramname1 = new String[]{};
        String[] paramvalues1 = new String[]{};
        String[] headername1 = new String[]{"apikey"};
        String[] headervals1 = new String[]{apiKey};
        try {
            JSONArray resp = new JSONArray(HttpUtils.makeGet(baseUrl, paramname1, paramvalues1, headername1, headervals1));
            for (int i = 0; i < resp.length(); ++i) {
                if (!resp.getJSONObject(i).getString("name").startsWith("dev")) continue;
                return resp.getJSONObject(i).getString("name");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setCallback(String apiKey, String userId, String devId, String botName, String callback) {
        String baseUrl = Constants.SMAPIConsts.SET_BOT_ENV_CALLBACK.replace("__BOTNAME", botName).replace("__DEVID", devId);
        String[] headername2 = new String[]{"content-type", "apikey"};
        String[] headervals2 = new String[]{"application/x-www-form-urlencoded", apiKey};
        try {
            HttpUtils.makePut(baseUrl, "url=" + URLEncoder.encode(callback, "UTF-8"), headername2, headervals2);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getBotSpec(String apiKey, String botName) throws ClientProtocolException, IOException {
        String url = Constants.SMAPIConsts.GET_BOT_SPEC.replace("__BOTNAME", botName);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Accept", "application/json");
        httpGet.setHeader("apikey", apiKey);
        try (CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httpGet);){
            JSONObject response = new JSONObject();
            response.put("status", resp.getStatusLine().getStatusCode());
            response.put("body", (Object)IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)"UTF-8"));
            JSONObject jSONObject = response;
            return jSONObject;
        }
    }

    public static JSONObject getBotMeta(String apiKey, String botName) throws ClientProtocolException, IOException {
        String url = Constants.SMAPIConsts.GET_BOT_META.replace("__BOTNAME", botName);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Accept", "application/json");
        httpGet.setHeader("apikey", apiKey);
        try (CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httpGet);){
            JSONObject response = new JSONObject();
            response.put("status", resp.getStatusLine().getStatusCode());
            response.put("body", (Object)IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)"UTF-8"));
            JSONObject jSONObject = response;
            return jSONObject;
        }
    }

    public static JSONObject uploadJavaBot(File botFile, String botName, String apiKey) throws ClientProtocolException, IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String uploadUrl = Constants.SMAPIConsts.UPLOAD_JAVA_BOT.replace("__BOTNAME", botName).replace("__APIKEY", apiKey);
        HttpPost httppost = new HttpPost(uploadUrl);
        httppost.addHeader("apikey", apiKey);
        FileBody botFileBody = new FileBody(botFile);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("botCode", (ContentBody)botFileBody).build();
        httppost.setEntity(reqEntity);
        try (CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httppost);){
            HttpEntity resEntity = resp.getEntity();
            JSONObject response = new JSONObject();
            response.put("status", resp.getStatusLine().getStatusCode());
            response.put("body", (Object)IOUtils.toString((InputStream)resEntity.getContent(), (String)"UTF-8"));
            EntityUtils.consume((HttpEntity)resEntity);
            JSONObject jSONObject = response;
            return jSONObject;
        }
    }

    public static JSONObject createGit(String botKey) throws ClientProtocolException, IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String url = Constants.SMAPIConsts.GIT_CREATE;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        formParams.add(new BasicNameValuePair("reponame", botKey));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        try (CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httpPost);){
            HttpEntity resEntity = resp.getEntity();
            JSONObject response = new JSONObject();
            response.put("status", resp.getStatusLine().getStatusCode());
            response.put("body", (Object)IOUtils.toString((InputStream)resEntity.getContent(), (String)"UTF-8"));
            EntityUtils.consume((HttpEntity)resEntity);
            JSONObject jSONObject = response;
            return jSONObject;
        }
    }
}

