/*
 * Decompiled with CFR 0.152.
 */
package io.gupshup.maven.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class HttpUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeGet(String baseUrl, String[] paramname, String[] paramvalues, String[] headername, String[] headervals) throws UnsupportedEncodingException {
        StringBuilder urlstr = new StringBuilder(baseUrl);
        if (baseUrl.contains("?")) {
            if (!baseUrl.endsWith("&")) {
                urlstr.append("&");
            }
        } else {
            urlstr.append("?");
        }
        for (int i = 0; i < paramname.length; ++i) {
            if (i > 0) {
                urlstr.append("&");
            }
            urlstr.append(paramname[i]);
            urlstr.append("=");
            urlstr.append(URLEncoder.encode(paramvalues[i], "UTF-8"));
        }
        HttpURLConnection conn = null;
        InputStream is = null;
        try {
            String resp;
            URL url = new URL(urlstr.toString());
            conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(30000);
            conn.setConnectTimeout(30000);
            for (int i = 0; i < headername.length; ++i) {
                conn.setRequestProperty(headername[i], headervals[i]);
            }
            String string = resp = HttpUtils.convertStreamToString(conn.getInputStream());
            return string;
        }
        catch (Exception ex) {
            System.out.println("Making GET:" + urlstr.toString());
            System.err.println("Exception : " + ex.getMessage());
            String errorResp = "";
            try {
                errorResp = HttpUtils.convertStreamToString(conn.getErrorStream());
            }
            catch (IOException e) {
                System.err.println("Exception : " + ex.getMessage());
            }
            try {
                System.err.println("Http request error url : " + urlstr + "; respCode : " + conn.getResponseCode() + "; response : " + errorResp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String convertStreamToString(InputStream is) throws IOException {
        return new String(HttpUtils.readFully(is), "UTF-8");
    }

    private static byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makePut(String baseUrl, String rawData, String[] headername, String[] headervals) {
        HttpURLConnection conn = null;
        InputStream is = null;
        try {
            String resp;
            URL url = new URL(baseUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("PUT");
            conn.setReadTimeout(30000);
            conn.setConnectTimeout(30000);
            for (int i = 0; i < headername.length; ++i) {
                conn.setRequestProperty(headername[i], headervals[i]);
            }
            conn.setRequestProperty("Content-Length", "" + Integer.toString(rawData.getBytes().length));
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStreamWriter connwriter = new OutputStreamWriter(conn.getOutputStream());
            connwriter.write(rawData);
            connwriter.flush();
            connwriter.close();
            String string = resp = HttpUtils.convertStreamToString(conn.getInputStream());
            return string;
        }
        catch (Exception ex) {
            System.out.println("Making PUT:" + baseUrl);
            System.err.println("Exception : " + ex.getMessage());
            String errorResp = "";
            try {
                errorResp = HttpUtils.convertStreamToString(conn.getErrorStream());
            }
            catch (IOException e) {
                System.err.println("Exception : " + ex.getMessage());
            }
            try {
                System.err.println("Http request error url : " + baseUrl + "; respCode : " + conn.getResponseCode() + "; response : " + errorResp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

