/*
 * Decompiled with CFR 0.152.
 */
package io.gupshup.maven;

import io.gupshup.maven.TCPTunnel;
import io.gupshup.maven.utils.SMAPIWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jetty.maven.plugin.JettyRunMojo;
import org.eclipse.jetty.server.Server;

@Mojo(name="run", threadSafe=true, defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST)
public class Run
extends JettyRunMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution execution;
    @Parameter(defaultValue="${project.artifacts}", readonly=true)
    protected Set<Artifact> projectArtifacts;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    protected List<String> pluginArtifacts;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File classesDirectory;
    @Parameter(property="port", defaultValue="8080")
    private String port;
    @Parameter(property="ngrokUrl")
    private String ngrokUrl;
    public static String userId = null;
    public static String devId = null;

    public void execute() throws MojoExecutionException {
        try {
            List resources = this.project.getResources();
            if (resources.size() < 1) {
                throw new MojoExecutionException("Project resources not found.");
            }
            Resource resource = (Resource)resources.get(0);
            File gsCfgPropsFile = new File(resource.getDirectory() + File.separator + "gsbot-cfg.properties");
            if (!gsCfgPropsFile.exists()) {
                throw new MojoExecutionException("gsbot-cfg.properties not found in src" + File.separator + "main" + File.separator + "resources");
            }
            Properties gsCfgProps = new Properties();
            gsCfgProps.load(new FileInputStream(gsCfgPropsFile));
            this.startBot(this.server, gsCfgProps.getProperty("gupshup.dev.apikey"), gsCfgProps.getProperty("gupshup.bot.name"));
            System.setProperty("jetty.port", this.port);
            this.scanIntervalSeconds = 1;
            ((JettyRunMojo)this).project = this.project;
            ((JettyRunMojo)this).execution = this.execution;
            this.reload = "automatic";
            ((JettyRunMojo)this).projectArtifacts = this.projectArtifacts;
            ((JettyRunMojo)this).pluginArtifacts = this.pluginArtifacts;
            ((JettyRunMojo)this).classesDirectory = this.classesDirectory;
            super.execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    public void startBot(final Server server, final String apiKey, final String botName) {
        final TCPTunnel tcpTunnel = new TCPTunnel();
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                    if (Run.this.ngrokUrl != null && !Run.this.ngrokUrl.trim().equals("")) {
                        Run.setCallback(apiKey, botName, Run.this.ngrokUrl + "/botcallback");
                    } else {
                        tcpTunnel.startTunnel(apiKey, botName, Integer.parseInt(Run.this.port));
                    }
                }
                catch (InterruptedException e) {
                    if (e.getMessage() != null) {
                        System.err.println("[ERROR] " + e.getMessage());
                    }
                    tcpTunnel.stopTunnel(server);
                    try {
                        server.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
        });
        th.start();
    }

    public static void setCallback(String apiKey, String botName, String callback) {
        if (userId == null) {
            userId = SMAPIWrapper.getUserId(apiKey);
            System.out.println("[INFO] ");
        }
        if (devId == null) {
            devId = SMAPIWrapper.getDevId(apiKey, userId, botName);
        }
        SMAPIWrapper.setCallback(apiKey, userId, devId, botName, callback);
        System.out.println("[INFO] --- Bot Started ---");
        System.out.println("[INFO] You can use your bot on Gupshup Proxy Bot using: proxy " + botName + "$" + devId + "\n\n------------------------------------------------------------------------\n");
    }
}

