/*
 * Decompiled with CFR 0.152.
 */
package io.gupshup.maven;

import io.gupshup.maven.utils.SMAPIWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.json.JSONObject;

@Mojo(name="deploy", threadSafe=true, defaultPhase=LifecyclePhase.DEPLOY, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class Deploy
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            File projectBuild = new File(this.project.getBuild().getDirectory() + File.separator + this.project.getBuild().getFinalName() + ".jar");
            if (!projectBuild.exists()) {
                throw new MojoExecutionException("Build the project first! e.g. clean package");
            }
            List resources = this.project.getResources();
            if (resources.size() < 1) {
                throw new MojoExecutionException("Project resources not found.");
            }
            Resource resource = (Resource)resources.get(0);
            File gsCfgPropsFile = new File(resource.getDirectory() + File.separator + "gsbot-cfg.properties");
            if (!gsCfgPropsFile.exists()) {
                throw new MojoExecutionException("gsbot-cfg.properties not found in src" + File.separator + "main" + File.separator + "resources");
            }
            Properties gsCfgProps = new Properties();
            gsCfgProps.load(new FileInputStream(gsCfgPropsFile));
            String botName = gsCfgProps.getProperty("gupshup.bot.name").trim();
            String apiKey = gsCfgProps.getProperty("gupshup.dev.apikey").trim();
            if (botName == null || botName.equals("") || apiKey == null || botName.equals("")) {
                throw new MojoExecutionException("gsbot-cfg.properties ==> required configuration not found");
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------ ");
            this.getLog().info((CharSequence)("Deploying " + this.project.getName() + " " + this.project.getBuild().getFinalName()));
            this.getLog().info((CharSequence)"------------------------------------------------------------------------ ");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Started Bot Deployment...");
            this.getLog().info((CharSequence)"");
            JSONObject resp = SMAPIWrapper.uploadJavaBot(projectBuild, botName, apiKey);
            if (resp.getInt("status") != 200) {
                throw new MojoExecutionException("Deployment failed: " + resp.getString("body"));
            }
            this.getLog().info((CharSequence)("Response body: " + resp.getString("body")));
            this.getLog().info((CharSequence)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }
}

