/*
 * Decompiled with CFR 0.152.
 */
package io.gupshup.maven;

import io.gupshup.maven.utils.Constants;
import io.gupshup.maven.utils.SMAPIWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.transport.URIish;
import org.json.JSONObject;

@Mojo(name="create", threadSafe=true, defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class Create
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="apiKey", required=true)
    private String apiKey;
    @Parameter(property="botName", required=true)
    private String botName;
    @Parameter(property="description", required=false)
    private String description;

    public void execute() throws MojoExecutionException {
        try {
            List resources = this.project.getResources();
            if (resources.size() < 1) {
                throw new MojoExecutionException("Project resources not found.");
            }
            Resource resource = (Resource)resources.get(0);
            File gsCfgPropsFile = new File(resource.getDirectory() + File.separator + "gsbot-cfg.properties");
            if (!gsCfgPropsFile.exists()) {
                throw new MojoExecutionException("gsbot-cfg.properties not found in src" + File.separator + "main" + File.separator + "resources");
            }
            Properties gsCfgProps = new Properties();
            gsCfgProps.load(new FileInputStream(gsCfgPropsFile));
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------ ");
            this.getLog().info((CharSequence)("Creating bot " + this.botName + " for " + this.project.getName()));
            this.getLog().info((CharSequence)"------------------------------------------------------------------------ ");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Configuring gsbot-cfg.properties");
            JSONObject createBotResp = SMAPIWrapper.createBot(this.apiKey, this.botName, this.description);
            if (createBotResp.getInt("status") != 200) {
                throw new MojoExecutionException(createBotResp.getString("body"));
            }
            String botKey = new JSONObject(createBotResp.getString("body")).getString("botkey");
            gsCfgProps.setProperty("gupshup.dev.apikey", this.apiKey);
            gsCfgProps.setProperty("gupshup.bot.name", this.botName);
            gsCfgProps.setProperty("gupshup.bot.key", botKey);
            gsCfgProps.store(new FileOutputStream(gsCfgPropsFile), null);
            this.getLog().info((CharSequence)"Creating bot repository.");
            SMAPIWrapper.createGit(botKey);
            this.getLog().info((CharSequence)"Synching with bot repository.");
            String userId = SMAPIWrapper.getUserId(this.apiKey);
            if (userId != null) {
                String gitUrl = Constants.SMAPIConsts.GIT_URL.replace("__USERID", userId).replace("__APIKEY", this.apiKey).replace("__BOTKEY", botKey);
                boolean isSuccess = this.cloneBotRepo(gitUrl);
                if (!isSuccess) {
                    this.getLog().info((CharSequence)"");
                    this.getLog().warn((CharSequence)"Failed to sync with bot repository.");
                }
            } else {
                this.getLog().info((CharSequence)"");
                this.getLog().error((CharSequence)"Failed to sync with bot repository.");
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Bot created successfully!");
            this.getLog().info((CharSequence)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private boolean cloneBotRepo(String gitUrl) {
        try {
            InitCommand initCommand = Git.init().setDirectory(this.project.getBasedir());
            Git git = initCommand.call();
            RemoteAddCommand remoteAddCommand = git.remoteAdd();
            remoteAddCommand.setName("origin");
            remoteAddCommand.setUri(new URIish(gitUrl));
            remoteAddCommand.call();
            FetchCommand fetchCommand = git.fetch();
            fetchCommand.call();
            CheckoutCommand checkoutCommand = git.checkout();
            checkoutCommand.setCreateBranch(true).setName("master").setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/master").call();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

