/*
 * Decompiled with CFR 0.152.
 */
package io.gupshup.maven;

import io.gupshup.maven.utils.Constants;
import io.gupshup.maven.utils.SMAPIWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.transport.URIish;
import org.json.JSONObject;

@Mojo(name="add", threadSafe=true, defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class Add
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="apiKey", required=true)
    private String apiKey;
    @Parameter(property="botName", required=true)
    private String botName;

    public void execute() throws MojoExecutionException {
        try {
            block10: {
                List resources = this.project.getResources();
                if (resources.size() < 1) {
                    throw new MojoExecutionException("Project resources not found.");
                }
                Resource resource = (Resource)resources.get(0);
                File gsCfgPropsFile = new File(resource.getDirectory() + File.separator + "gsbot-cfg.properties");
                if (!gsCfgPropsFile.exists()) {
                    throw new MojoExecutionException("gsbot-cfg.properties not found in src" + File.separator + "main" + File.separator + "resources");
                }
                Properties gsCfgProps = new Properties();
                gsCfgProps.load(new FileInputStream(gsCfgPropsFile));
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"------------------------------------------------------------------------ ");
                this.getLog().info((CharSequence)("Adding bot " + this.botName + " for " + this.project.getName()));
                this.getLog().info((CharSequence)"------------------------------------------------------------------------ ");
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"Fetching bot details...");
                JSONObject getBotSpecResp = SMAPIWrapper.getBotSpec(this.apiKey, this.botName);
                if (getBotSpecResp.getInt("status") != 200) {
                    throw new MojoExecutionException(getBotSpecResp.getString("body"));
                }
                String botKey = new JSONObject(getBotSpecResp.getString("body")).getString("uuid");
                this.getLog().info((CharSequence)"Configuring gsbot-cfg.properties");
                gsCfgProps.setProperty("gupshup.dev.apikey", this.apiKey);
                gsCfgProps.setProperty("gupshup.bot.name", this.botName);
                gsCfgProps.setProperty("gupshup.bot.key", botKey);
                gsCfgProps.store(new FileOutputStream(gsCfgPropsFile), null);
                SMAPIWrapper.createGit(botKey);
                this.getLog().info((CharSequence)"Synching with bot repository.");
                String userId = SMAPIWrapper.getUserId(this.apiKey);
                if (userId != null) {
                    String gitUrl = Constants.SMAPIConsts.GIT_URL.replace("__USERID", userId).replace("__APIKEY", this.apiKey).replace("__BOTKEY", botKey);
                    try {
                        this.cloneBotRepo(gitUrl);
                    }
                    catch (Exception e) {
                        this.getLog().info((CharSequence)"");
                        if (e.getMessage() != null) {
                            this.getLog().warn((CharSequence)e.getMessage());
                            break block10;
                        }
                        this.getLog().warn((CharSequence)"Failed to sync with bot repository.");
                    }
                } else {
                    this.getLog().info((CharSequence)"");
                    this.getLog().error((CharSequence)"Failed to sync with bot repository.");
                }
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Bot added successfully!");
            this.getLog().info((CharSequence)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private void cloneBotRepo(String gitUrl) throws Exception {
        InitCommand initCommand = Git.init().setDirectory(this.project.getBasedir());
        Git git = initCommand.call();
        RemoteAddCommand remoteAddCommand = git.remoteAdd();
        remoteAddCommand.setName("origin");
        remoteAddCommand.setUri(new URIish(gitUrl));
        remoteAddCommand.call();
        FetchCommand fetchCommand = git.fetch();
        fetchCommand.call();
        CheckoutCommand checkoutCommand = git.checkout();
        checkoutCommand.setCreateBranch(true).setName("master").setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/master").call();
    }
}

