/*
 * Copyright 2017 Gupshup.io. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gupshup.maven.utils;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import io.gupshup.maven.utils.Constants.SMAPIConsts;

/**
 * @author Abhishek
 */
public class SMAPIWrapper {
    public static JSONObject createBot(String apiKey, String botName, String description)
	    throws ClientProtocolException, IOException {
	String url = SMAPIConsts.CREATE_BOT.replace("__BOTNAME", botName);

	CloseableHttpClient httpclient = HttpClients.createDefault();

	HttpPut httpPut = new HttpPut(url);

	ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
	formParams.add(new BasicNameValuePair("lang", "java"));

	if (description != null)
	    formParams.add(new BasicNameValuePair("description", description));

	httpPut.setEntity(new UrlEncodedFormEntity(formParams));

	httpPut.setHeader("apikey", apiKey);
	httpPut.setHeader("Content-Type", "application/x-www-form-urlencoded");

	// System.out.println("Executing request " + httpPut.getRequestLine());
	try (CloseableHttpResponse resp = httpclient.execute(httpPut)) {
	    JSONObject response = new JSONObject();
	    response.put("status", resp.getStatusLine().getStatusCode());
	    response.put("body", resp.getEntity().getContent() == null ? "{}"
		    : (IOUtils.toString(resp.getEntity().getContent(), "UTF-8")));

	    return response;
	}
    }

    public static String getUserId(String apiKey) {
	String baseUrl = SMAPIConsts.GET_USER_PROFILE.replace("__APIKEY", apiKey);
	String[] paramname = {};
	String[] paramvalues = {};
	String[] headername = { "apikey" };
	String[] headervals = { apiKey };

	try {
	    JSONObject resp = new JSONObject(
		    HttpUtils.makeGet(baseUrl, paramname, paramvalues, headername, headervals));
	    return resp.getString("userid");
	} catch (UnsupportedEncodingException e) {
	    e.printStackTrace();
	}

	return null;
    }

    public static String getDevId(String apiKey, String userId, String botName) {
	String baseUrl = SMAPIConsts.GET_BOT_ENV_LIST.replace("__USERID", userId).replace("__BOTNAME", botName);
	String[] paramname1 = {};
	String[] paramvalues1 = {};
	String[] headername1 = { "apikey" };
	String[] headervals1 = { apiKey };

	try {
	    JSONArray resp = new JSONArray(
		    HttpUtils.makeGet(baseUrl, paramname1, paramvalues1, headername1, headervals1));
	    for (int i = 0; i < resp.length(); i++) {
		if (resp.getJSONObject(i).getString("name").startsWith("dev")) {
		    return resp.getJSONObject(i).getString("name");
		}
	    }
	} catch (UnsupportedEncodingException e) {
	    e.printStackTrace();
	}

	return null;
    }

    public static void setCallback(String apiKey, String userId, String devId, String botName, String callback) {
	String baseUrl = SMAPIConsts.SET_BOT_ENV_CALLBACK.replace("__BOTNAME", botName).replace("__DEVID", devId);
	String[] headername2 = { "content-type", "apikey" };
	String[] headervals2 = { "application/x-www-form-urlencoded", apiKey };

	try {
	    HttpUtils.makePut(baseUrl, "url=" + URLEncoder.encode(callback, "UTF-8"), headername2, headervals2);
	} catch (UnsupportedEncodingException e) {
	    e.printStackTrace();
	}
    }

    public static JSONObject getBotSpec(String apiKey, String botName) throws ClientProtocolException, IOException {
	String url = SMAPIConsts.GET_BOT_SPEC.replace("__BOTNAME", botName);

	CloseableHttpClient httpclient = HttpClients.createDefault();

	HttpGet httpGet = new HttpGet(url);
	httpGet.setHeader("Accept", "application/json");
	httpGet.setHeader("apikey", apiKey);

	// System.out.println("Executing request " + httpGet.getRequestLine());
	try (CloseableHttpResponse resp = httpclient.execute(httpGet)) {
	    JSONObject response = new JSONObject();
	    response.put("status", resp.getStatusLine().getStatusCode());
	    response.put("body", IOUtils.toString(resp.getEntity().getContent(), "UTF-8"));

	    return response;
	}
    }

    public static JSONObject getBotMeta(String apiKey, String botName) throws ClientProtocolException, IOException {
	String url = SMAPIConsts.GET_BOT_META.replace("__BOTNAME", botName);

	CloseableHttpClient httpclient = HttpClients.createDefault();

	HttpGet httpGet = new HttpGet(url);
	httpGet.setHeader("Accept", "application/json");
	httpGet.setHeader("apikey", apiKey);

	// System.out.println("Executing request " + httpGet.getRequestLine());
	try (CloseableHttpResponse resp = httpclient.execute(httpGet)) {
	    JSONObject response = new JSONObject();
	    response.put("status", resp.getStatusLine().getStatusCode());
	    response.put("body", IOUtils.toString(resp.getEntity().getContent(), "UTF-8"));

	    return response;
	}
    }

    public static JSONObject uploadJavaBot(File botFile, String botName, String apiKey)
	    throws ClientProtocolException, IOException {
	CloseableHttpClient httpclient = HttpClients.createDefault();
	String uploadUrl = SMAPIConsts.UPLOAD_JAVA_BOT.replace("__BOTNAME", botName).replace("__APIKEY", apiKey);
	HttpPost httppost = new HttpPost(uploadUrl);
	httppost.addHeader("apikey", apiKey);

	FileBody botFileBody = new FileBody(botFile);
	HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("botCode", botFileBody).build();
	httppost.setEntity(reqEntity);

	// System.out.println("executing request " + httppost.getRequestLine());
	try (CloseableHttpResponse resp = httpclient.execute(httppost)) {
	    HttpEntity resEntity = resp.getEntity();

	    JSONObject response = new JSONObject();
	    response.put("status", resp.getStatusLine().getStatusCode());
	    response.put("body", IOUtils.toString(resEntity.getContent(), "UTF-8"));

	    EntityUtils.consume(resEntity);

	    return response;
	}
    }

    public static JSONObject createGit(String botKey) throws ClientProtocolException, IOException {
	CloseableHttpClient httpclient = HttpClients.createDefault();
	String url = SMAPIConsts.GIT_CREATE;
	HttpPost httpPost = new HttpPost(url);

	ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
	formParams.add(new BasicNameValuePair("reponame", botKey));
	httpPost.setEntity(new UrlEncodedFormEntity(formParams));
	httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");

	// System.out.println("Executing request " + httpPost.getRequestLine());
	try (CloseableHttpResponse resp = httpclient.execute(httpPost)) {
	    HttpEntity resEntity = resp.getEntity();

	    JSONObject response = new JSONObject();
	    response.put("status", resp.getStatusLine().getStatusCode());
	    response.put("body", IOUtils.toString(resEntity.getContent(), "UTF-8"));

	    EntityUtils.consume(resEntity);

	    return response;
	}
    }
}