/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.wmwtr.springbootdevtools.Restart;

import io.gitlab.wmwtr.springbootdevtools.Restart.ClassLoaderExcludeFiles;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import org.springframework.core.SmartClassLoader;

public class RestartClassLoader
extends URLClassLoader
implements SmartClassLoader {
    public RestartClassLoader(ClassLoader parent, URL[] urls) {
        super(urls, parent);
    }

    public boolean isClassReloadable(Class<?> classType) {
        return classType.getClassLoader() instanceof RestartClassLoader;
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        if (resource != null) {
            return resource;
        }
        return this.getParent().getResource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException var4) {
                    c = Class.forName(name, false, this.getParent());
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (ClassLoaderExcludeFiles.getInstance().getPath(name) == null) {
            return super.findClass(name);
        }
        throw new ClassNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getData(String name) {
        String classpath = this.getURLs()[0].getPath();
        if (classpath.endsWith("/")) {
            classpath = classpath.substring(0, classpath.length() - 1);
        }
        try {
            classpath = URLDecoder.decode(classpath, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String path = classpath + "\\" + name.replace(".", "\\") + ".class";
        File file = new File(path);
        if (file.exists()) {
            FileInputStream in = null;
            ByteArrayOutputStream out = null;
            try {
                in = new FileInputStream(file);
                out = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int size = 0;
                while ((size = in.read(buffer)) != -1) {
                    out.write(buffer, 0, size);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return out.toByteArray();
        }
        return null;
    }
}

