/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.wmwtr.springbootdevtools.FileWatch;

import io.gitlab.wmwtr.springbootdevtools.FileWatch.ChangedFile;
import io.gitlab.wmwtr.springbootdevtools.FileWatch.ChangedFileRepository;
import java.io.File;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;

public class FileWatchListener
extends FileAlterationListenerAdaptor {
    private final ChangedFileRepository repository;

    public FileWatchListener(ChangedFileRepository repository) {
        this.repository = repository;
    }

    public void onDirectoryChange(File directory) {
    }

    public void onDirectoryDelete(File directory) {
        this.repository.put(new ChangedFile(ChangedFile.FileType.DIR, directory, ChangedFile.ChangedType.DELETE, this.repository.getSourceDir()));
    }

    public void onDirectoryCreate(File directory) {
        this.repository.put(new ChangedFile(ChangedFile.FileType.DIR, directory, ChangedFile.ChangedType.ADD, this.repository.getSourceDir()));
    }

    public void onFileChange(File file) {
        if (file.getName().endsWith(".java")) {
            this.repository.put(new ChangedFile(ChangedFile.FileType.JAVA, file, ChangedFile.ChangedType.MODIFY, this.repository.getSourceDir()));
        } else {
            this.repository.put(new ChangedFile(ChangedFile.FileType.OTHER, file, ChangedFile.ChangedType.MODIFY, this.repository.getSourceDir()));
        }
    }

    public void onFileDelete(File file) {
        if (file.getName().endsWith(".java")) {
            this.repository.put(new ChangedFile(ChangedFile.FileType.JAVA, file, ChangedFile.ChangedType.DELETE, this.repository.getSourceDir()));
        } else {
            this.repository.put(new ChangedFile(ChangedFile.FileType.OTHER, file, ChangedFile.ChangedType.DELETE, this.repository.getSourceDir()));
        }
    }

    public void onFileCreate(File file) {
        if (file.getName().endsWith(".java")) {
            this.repository.put(new ChangedFile(ChangedFile.FileType.JAVA, file, ChangedFile.ChangedType.ADD, this.repository.getSourceDir()));
        } else {
            this.repository.put(new ChangedFile(ChangedFile.FileType.OTHER, file, ChangedFile.ChangedType.ADD, this.repository.getSourceDir()));
        }
    }
}

