/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.wmwtr.springbootdevtools.FileWatch;

import io.gitlab.wmwtr.springbootdevtools.FileWatch.PatternSourceDirectoryStrategy;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class DefaultPatternSourceDirectoryStrategy
implements PatternSourceDirectoryStrategy {
    private String enctype = "UTF-8";

    public void setEnctype(String enc) {
        this.enctype = enc;
    }

    private URL[] getClassPathDirs(Thread var1) {
        ArrayList<URL> urls = new ArrayList<URL>();
        URL[] var2 = DefaultPatternSourceDirectoryStrategy.urlsFromClassLoader(var1.getContextClassLoader());
        int var3 = var2.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            if (!this.isDirectoryUrl(var2[var4].toString())) continue;
            urls.add(var2[var4]);
        }
        return urls.toArray(new URL[0]);
    }

    @Override
    public Collection<File> getSourceDir(Thread var1) {
        URL[] var2 = this.getClassPathDirs(var1);
        String classPath = this.getFirstBaseUrls(var2).getPath();
        File parent = new File(classPath).getParentFile().getParentFile();
        File watchFile = new File(parent.getPath() + "//src//main//java");
        File watchFile2 = new File(parent.getPath() + "//src//main//Resources");
        LinkedList<File> var3 = new LinkedList<File>();
        if (watchFile.exists()) {
            var3.add(watchFile);
        }
        if (watchFile2.exists()) {
            var3.add(watchFile2);
        }
        return var3;
    }

    private URL getFirstBaseUrls(URL[] classPathDirs) {
        try {
            return new URL(URLDecoder.decode(classPathDirs[0].toString(), this.enctype));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static URL[] urlsFromClassLoader(ClassLoader classLoader) {
        return classLoader instanceof URLClassLoader ? ((URLClassLoader)classLoader).getURLs() : new URL[]{};
    }

    private boolean isDirectoryUrl(String urlString) {
        return urlString.startsWith("file:") && urlString.endsWith("/");
    }
}

