/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.wmwtr.springbootdevtools.FileWatch;

import io.gitlab.wmwtr.springbootdevtools.AutoCompile.AutoCompiler;
import io.gitlab.wmwtr.springbootdevtools.FileWatch.ChangedFile;
import java.io.File;
import java.util.LinkedList;
import org.springframework.util.Assert;

public class ChangedFileRepository {
    private final LinkedList<ChangedFile> files = new LinkedList();
    private final LinkedList<AutoCompiler> compilers;
    private final File sourceDir;
    private boolean isNotify = false;

    public ChangedFileRepository(Boolean isNotify, File sourceDir, AutoCompiler ... compilers) {
        this.isNotify = isNotify;
        this.compilers = new LinkedList();
        this.sourceDir = sourceDir;
        for (AutoCompiler var1 : compilers) {
            this.compilers.add(var1);
        }
    }

    public ChangedFileRepository(Boolean isNotify, File sourceDir) {
        this.isNotify = isNotify;
        this.compilers = new LinkedList();
        this.sourceDir = sourceDir;
    }

    public void addAutoCompiler(AutoCompiler compiler) {
        this.compilers.addLast(compiler);
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ChangedFile changedFile) {
        Assert.notNull((Object)changedFile, (String)"changedFile must not be null");
        if (changedFile != null) {
            ChangedFileRepository changedFileRepository = this;
            synchronized (changedFileRepository) {
                this.files.add(changedFile);
            }
            if (this.isNotify) {
                AutoCompiler compiler = this.compilers.pop();
                this.compilers.addLast(compiler);
                compiler.trigger();
            }
        }
    }

    public synchronized ChangedFile poll() {
        return this.files.pollFirst();
    }

    public synchronized ChangedFile[] pollAll() {
        ChangedFile[] changedFiles = this.files.toArray(new ChangedFile[0]);
        this.files.clear();
        return changedFiles;
    }

    public synchronized boolean isEmpty() {
        return this.files.isEmpty();
    }
}

