/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.wmwtr.springbootdevtools.FileWatch;

import java.io.File;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ChangedFile {
    private final File sourceDir;
    private FileType fileType;
    private final ChangedType changedType;
    private final File file;

    public ChangedFile(FileType fileType, File file, ChangedType type, File sourceDir) {
        Assert.notNull((Object)((Object)fileType), (String)"FileType must not be null");
        Assert.notNull((Object)file, (String)"File must not be null");
        Assert.notNull((Object)((Object)type), (String)"Type must not be null");
        Assert.notNull((Object)sourceDir, (String)"sourceDir must not be null");
        this.fileType = fileType;
        this.file = file;
        this.changedType = type;
        this.sourceDir = sourceDir;
    }

    public String getRelativeName() {
        File directory = this.sourceDir.getAbsoluteFile();
        File file = this.file.getAbsoluteFile();
        String directoryName = StringUtils.cleanPath((String)directory.getPath());
        String fileName = StringUtils.cleanPath((String)file.getPath());
        Assert.state((boolean)fileName.startsWith(directoryName), () -> "The file " + fileName + " is not contained in the source directory " + directoryName);
        return fileName.substring(directoryName.length() + 1);
    }

    public File getFile() {
        return this.file;
    }

    public ChangedType getChangedType() {
        return this.changedType;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public static enum ChangedType {
        ADD,
        MODIFY,
        DELETE;

    }

    public static enum FileType {
        DIR,
        JAVA,
        OTHER;

    }
}

