/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.wmwtr.springbootdevtools.AutoCompile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class ProcessClassPathFiles {
    private static final Log logger = LogFactory.getLog(ProcessClassPathFiles.class);
    private final File classPath;
    private final Compile compile;

    public ProcessClassPathFiles(File classPath) {
        Assert.notNull((Object)classPath, (String)"classPath must not be null");
        this.classPath = classPath;
        this.compile = new Compile();
    }

    private String convertToSuffixClass(String name) {
        if (name.contains(".")) {
            name = name.substring(0, name.indexOf(".")) + ".class";
        }
        return name;
    }

    private File getTargetFile(String relativeName) {
        if (relativeName.endsWith(".java")) {
            return new File(this.classPath + "//" + this.convertToSuffixClass(relativeName));
        }
        return new File(this.classPath + "//" + relativeName);
    }

    public void delDir(String relativeName) throws IOException {
        File file = this.getTargetFile(relativeName);
        if (file.exists()) {
            FileUtils.deleteDirectory((File)file);
        }
    }

    public void createDir(String relativeName) throws IOException {
        File file = this.getTargetFile(relativeName);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public void createClassFile(File ... javaFile) {
        this.compile.compile(javaFile);
    }

    public void createOtherFile(String relativeName, File src) throws IOException {
        String var1 = this.classPath + "//" + relativeName;
        FileUtils.copyFileToDirectory((File)src, (File)new File(var1.substring(0, var1.length() - src.getName().length())));
    }

    public void delClassFile(String relativeName) throws IOException {
        File file = this.getTargetFile(relativeName);
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
    }

    public void delOtherFile(String relativeName) throws IOException {
        File file = this.getTargetFile(relativeName);
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
    }

    private class Compile {
        List<String> options = new ArrayList<String>();

        Compile() {
            this.options.add("-d");
            this.options.add(ProcessClassPathFiles.this.classPath.getPath());
        }

        private void compile(File ... javaFile) {
            String[] var1 = new String[javaFile.length];
            for (int var2 = 0; var2 < var1.length; ++var2) {
                var1[var2] = javaFile[var2].getPath();
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            DiagnosticCollector collector = new DiagnosticCollector();
            StandardJavaFileManager manager = compiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> javaFileObjects = manager.getJavaFileObjects(var1);
            JavaCompiler.CompilationTask task = compiler.getTask(null, manager, collector, this.options, null, javaFileObjects);
            collector.getDiagnostics().forEach(item -> logger.info((Object)item.toString()));
            task.call();
        }
    }
}

