/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.wmwtr.springbootdevtools.AutoCompile;

import io.gitlab.wmwtr.springbootdevtools.AutoCompile.ProcessClassPathFiles;
import io.gitlab.wmwtr.springbootdevtools.FileWatch.ChangedFile;
import io.gitlab.wmwtr.springbootdevtools.FileWatch.ChangedFileRepository;
import io.gitlab.wmwtr.springbootdevtools.Restart.Restarter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoCompiler {
    private static final Log logger = LogFactory.getLog(AutoCompiler.class);
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private final ProcessClassPathFiles processor;
    private final ChangedFileRepository repository;
    private final AutoCompilerThread execThread;
    private boolean onTriggerEnter = false;

    public AutoCompiler(ChangedFileRepository repository, File classPathDir) {
        this.repository = repository;
        this.execThread = new AutoCompilerThread();
        this.processor = new ProcessClassPathFiles(classPathDir);
    }

    public void start() {
        logger.info((Object)("[" + this.repository.getSourceDir() + "] has started to monitor"));
        this.execThread.start();
    }

    public Thread getExecThread() {
        return this.execThread;
    }

    private void convertToWorkQueue() {
        this.workQueue.add(new Runnable(){

            @Override
            public void run() {
                try {
                    AutoCompiler.this.MessageProcess();
                }
                catch (Exception e) {
                    logger.error((Object)"Fail to process files", (Throwable)e);
                }
            }
        });
    }

    private void MessageProcess() throws IOException {
        ChangedFile[] changedFiles;
        for (ChangedFile file : changedFiles = this.repository.pollAll()) {
            if (file.getChangedType() == ChangedFile.ChangedType.ADD) {
                if (file.getFileType() == ChangedFile.FileType.DIR) {
                    this.processor.createDir(file.getRelativeName());
                    continue;
                }
                if (file.getFileType() == ChangedFile.FileType.JAVA) {
                    this.processor.createClassFile(file.getFile());
                    continue;
                }
                if (file.getFileType() != ChangedFile.FileType.OTHER) continue;
                this.processor.createOtherFile(file.getRelativeName(), file.getFile());
                continue;
            }
            if (file.getChangedType() == ChangedFile.ChangedType.DELETE) {
                if (file.getFileType() == ChangedFile.FileType.DIR) {
                    this.processor.delDir(file.getRelativeName());
                    continue;
                }
                if (file.getFileType() == ChangedFile.FileType.JAVA) {
                    this.processor.delClassFile(file.getRelativeName());
                    continue;
                }
                if (file.getFileType() != ChangedFile.FileType.OTHER) continue;
                this.processor.delOtherFile(file.getRelativeName());
                continue;
            }
            if (file.getChangedType() != ChangedFile.ChangedType.MODIFY) continue;
            if (file.getFileType() == ChangedFile.FileType.JAVA) {
                this.processor.delClassFile(file.getRelativeName());
                this.processor.createClassFile(file.getFile());
                continue;
            }
            if (file.getFileType() != ChangedFile.FileType.OTHER) continue;
            this.processor.delOtherFile(file.getRelativeName());
            this.processor.createOtherFile(file.getRelativeName(), file.getFile());
        }
    }

    private synchronized void setTrueOnTriggerEnter() {
        this.onTriggerEnter = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger() {
        this.setTrueOnTriggerEnter();
        AutoCompilerThread autoCompilerThread = this.execThread;
        synchronized (autoCompilerThread) {
            this.execThread.notify();
        }
    }

    private class AutoCompilerThread
    extends Thread {
        public AutoCompilerThread() {
            this.setName("AutoCompiler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    AutoCompilerThread autoCompilerThread = this;
                    synchronized (autoCompilerThread) {
                        if (!AutoCompiler.this.onTriggerEnter) {
                            this.wait();
                        } else {
                            AutoCompiler autoCompiler = AutoCompiler.this;
                            synchronized (autoCompiler) {
                                AutoCompiler.this.convertToWorkQueue();
                                Runnable r = (Runnable)AutoCompiler.this.workQueue.poll();
                                if (r != null) {
                                    r.run();
                                }
                                AutoCompiler.this.onTriggerEnter = false;
                            }
                            Restarter.getInstance().restart();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

