/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rujal_sh.commons;

import io.gitlab.rujal_sh.commons.SqlExecutions;
import io.gitlab.rujal_sh.db.config.domain.DataSourceConfig;
import io.gitlab.rujal_sh.db.config.repo.DataSourceConfigRepository;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class TenantDataSource
implements Serializable {
    private final GenericWebApplicationContext context;
    private final BeanFactory beanFactory;
    public static Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    public TenantDataSource(GenericWebApplicationContext context, BeanFactory beanFactory) {
        this.context = context;
        this.beanFactory = beanFactory;
    }

    @Lazy
    private static class AssignTenantDataSource
    extends SqlExecutions {
        private final BeanFactory beanFactory;
        private DataSourceConfigRepository dataSourceConfigRepository;

        @PostConstruct
        private void getAll() {
            this.dataSourceConfigRepository = (DataSourceConfigRepository)this.beanFactory.getBean(DataSourceConfigRepository.class);
            List configList = this.dataSourceConfigRepository.findAll();
            HashMap<String, DataSource> result = new HashMap<String, DataSource>();
            for (DataSourceConfig config : configList) {
                result.put(config.getName(), this.createDataSource(config));
            }
            dataSources = result;
        }

        public AssignTenantDataSource(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }
    }
}

