/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rujal_sh.commons;

import io.gitlab.rujal_sh.commons.utils.Constants;
import java.util.HashMap;
import javax.sql.DataSource;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

public class PersistenceJPAConfig
extends Constants {
    private static final Logger log = LoggerFactory.getLogger(PersistenceJPAConfig.class);
    private final JpaProperties jpaHibernateProperties;
    private final DataSource dataSource;
    private final MultiTenantConnectionProvider multiTenantConnectionProvider;
    private final CurrentTenantIdentifierResolver currentTenantIdentifierResolver;

    public PersistenceJPAConfig(JpaProperties jpaHibernateProperties, DataSource dataSource, MultiTenantConnectionProvider multiTenantConnectionProvider, CurrentTenantIdentifierResolver currentTenantIdentifierResolver, ApplicationContext applicationContext) {
        super(applicationContext);
        this.jpaHibernateProperties = jpaHibernateProperties;
        this.dataSource = dataSource;
        this.multiTenantConnectionProvider = multiTenantConnectionProvider;
        this.currentTenantIdentifierResolver = currentTenantIdentifierResolver;
    }

    @Bean
    @Primary
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        HashMap<String, Object> jpaPropertiesMap = new HashMap<String, Object>(this.jpaHibernateProperties.getProperties());
        jpaPropertiesMap.put("hibernate.multiTenancy", (Object)Constants.strategy);
        jpaPropertiesMap.put("hibernate.multi_tenant_connection_provider", this.multiTenantConnectionProvider);
        jpaPropertiesMap.put("hibernate.tenant_identifier_resolver", this.currentTenantIdentifierResolver);
        jpaPropertiesMap.put("hibernate.hbm2ddl.auto", "update");
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.dataSource);
        em.setPackagesToScan(Constants.basePackages);
        em.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        em.setJpaPropertyMap(jpaPropertiesMap);
        return em;
    }
}

