package io.gitlab.rujal_sh.commons.utils;

import io.gitlab.rujal_sh.annotation.Database_Based_MultiTenancy;
import io.gitlab.rujal_sh.annotation.StrategyType;
import io.gitlab.rujal_sh.schema.config.helper.annotation.Schema_Based_MultiTenancy;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

@Slf4j
@RequiredArgsConstructor
public class Constants {

    public static StrategyType strategy;
    public static String[] basePackages;

    public Constants(ApplicationContext applicationContext) {

        ClassPathScanningCandidateComponentProvider scanner =
                new ClassPathScanningCandidateComponentProvider(false);

        scanner.addIncludeFilter(new AnnotationTypeFilter(Database_Based_MultiTenancy.class));
        scanner.addIncludeFilter(new AnnotationTypeFilter(Schema_Based_MultiTenancy.class));

        List<String> autoConfigurationPackage = AutoConfigurationPackages.get(applicationContext.getAutowireCapableBeanFactory());

        String rootPackageName = autoConfigurationPackage.get(0).substring(0, autoConfigurationPackage.get(0).split("\\.")[0].length());
        Set<BeanDefinition> candidates = scanner.findCandidateComponents(rootPackageName);

        if (candidates.size() != 1) {
            if (candidates.size() != 0) {
                throw new RuntimeException("Either @Database_Based_MultiTenancy OR @Schema_Based_MultiTenancy should be used in Application");
            } else {
                log.info("MultiTenancy feature is Disabled");
            }
        } else {
            log.info("Bootstrapping Spring MultiTenancy");
            for (BeanDefinition bd : candidates) {
                try {
                    Database_Based_MultiTenancy annotation = Class.forName(bd.getBeanClassName()).getAnnotation(Database_Based_MultiTenancy.class);
                    if (annotation==null){
                        basePackages = Class.forName(bd.getBeanClassName()).getAnnotation(Schema_Based_MultiTenancy.class).basePackages();
                        strategy = StrategyType.SCHEMA;
                    }else{
                        basePackages = annotation.basePackages();
                        strategy = StrategyType.DATABASE;
                    }
                    basePackages = Stream.concat(Arrays.stream(basePackages), Arrays.stream(new String[]{"io.gitlab.rujal_sh.db.config.domain"})).toArray(String[]::new);
                    log.info("Using MultiTenancy BasePackage to Scan: {}", basePackages);
                    log.info("Using MultiTenancy Strategy: {}", strategy);
                } catch (ClassNotFoundException var11) {
                    log.error("Error in Detecting @EnableMultiTenancy annotation implementation");
                }
            }
        }
    }
}
