/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rujal_sh.schema;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"dataSource"})
public class MultiTenantConnectionProviderImpl
implements MultiTenantConnectionProvider {
    private final DataSource dataSource;

    MultiTenantConnectionProviderImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getAnyConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void releaseAnyConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public Connection getConnection(String tenantIdentifier) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setSchema(tenantIdentifier);
        return connection;
    }

    public void releaseConnection(String s, Connection connection) throws SQLException {
        connection.setSchema("public");
        this.releaseAnyConnection(connection);
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class aClass) {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) {
        return null;
    }
}

