/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rujal_sh.commons.utils;

import io.gitlab.rujal_sh.annotation.Database_Based_MultiTenancy;
import io.gitlab.rujal_sh.annotation.Schema_Based_MultiTenancy;
import io.gitlab.rujal_sh.annotation.StrategyType;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class Constants {
    private static final Logger log = LoggerFactory.getLogger(Constants.class);
    public static StrategyType strategy;
    public static String[] basePackages;

    public Constants(ApplicationContext applicationContext) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Database_Based_MultiTenancy.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Schema_Based_MultiTenancy.class));
        List autoConfigurationPackage = AutoConfigurationPackages.get((BeanFactory)applicationContext.getAutowireCapableBeanFactory());
        String rootPackageName = ((String)autoConfigurationPackage.get(0)).substring(0, ((String)autoConfigurationPackage.get(0)).split("\\.")[0].length());
        Set candidates = scanner.findCandidateComponents(rootPackageName);
        if (candidates.size() != 1) {
            if (candidates.size() != 0) {
                throw new RuntimeException("Either @Database_Based_MultiTenancy OR @Schema_Based_MultiTenancy should be used in Application");
            }
            log.info("MultiTenancy feature is Disabled");
        } else {
            log.info("Bootstrapping Spring MultiTenancy");
            for (BeanDefinition bd : candidates) {
                try {
                    Database_Based_MultiTenancy annotation = Class.forName(bd.getBeanClassName()).getAnnotation(Database_Based_MultiTenancy.class);
                    if (annotation == null) {
                        basePackages = Class.forName(bd.getBeanClassName()).getAnnotation(Schema_Based_MultiTenancy.class).basePackages();
                        strategy = StrategyType.SCHEMA;
                    } else {
                        basePackages = annotation.basePackages();
                        strategy = StrategyType.DATABASE;
                    }
                    basePackages = (String[])Stream.concat(Arrays.stream(basePackages), Arrays.stream(new String[]{"io.gitlab.rujal_sh.database"})).toArray(String[]::new);
                    log.info("Using MultiTenancy BasePackage to Scan: {}", (Object[])basePackages);
                    log.info("Using MultiTenancy Strategy: {}", (Object)strategy);
                }
                catch (ClassNotFoundException var11) {
                    log.error("Error in Detecting @EnableMultiTenancy annotation implementation");
                }
            }
        }
    }

    public Constants() {
    }
}

