package io.gitlab.rujal_sh.commons.interceptor;

import io.gitlab.rujal_sh.commons.TenantContext;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class RequestFilter implements Filter {

    @Override
    public void doFilter(
      ServletRequest request,
      ServletResponse response,
      FilterChain chain) throws IOException, ServletException {

        String tenantId = ((HttpServletRequest) request).getHeader("TenantId");
        if (tenantId != null){
            TenantContext.setCurrentTenant(tenantId);
            chain.doFilter(request, response);
        }else {
            response.getWriter().write("TenantId not present in the Request Header");
            ((HttpServletResponse) response).setStatus(400);
        }
    }

    public void destroy() {
        TenantContext.clear();
    }
}